% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpp.R
\docType{package}
\name{ggpp-package}
\alias{ggpp}
\alias{ggpp-package}
\title{ggpp: Grammar Extensions to 'ggplot2'}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Extensions to 'ggplot2' respecting the grammar of graphics paradigm. Geometries: geom_table(), geom_plot() and geom_grob() add insets to plots using native data coordinates, while geom_table_npc(), geom_plot_npc() and geom_grob_npc() do the same using "npc" coordinates through new aesthetics "npcx" and "npcy". Statistics: select observations based on 2D density. Positions: radial nudging away from a center point and nudging away from a line or curve; combined stacking and nudging; combined dodging and nudging.
}
\details{
Package 'ggpp' provides functions that extend the grammar of
graphics as implemented in 'ggplot2'. It attempts to stay true to the
original grammar and to respect the naming conventions used in 'ggplot2'.

Extensions provided:
\itemize{
\item Geoms adding support for plot, table and grob insets within the
gramamr. Geoms using a parallel pseudo-scale based on native plot coordinates
(npc) to allow annotations consistent with the grammar and so supporting
facets and grouping. Geoms for annotations on the edges of the plotting
area. Geom for easily drawing lines separating the quadrants of a plot.
\item Stats for filtering-out/filtering-in observations in regions of a
panel or group where the density of observations is high. Statistics
simultaneously computing summaries, optionally using different functions,
along x and y. Stat computing quadrant counts.
\item Position functions implementing multi-directional nudging based on the
data.
\item Scales. Pseudo-scales supporting npc coordinates for x and y.
\item Specializations of the \code{ggplot()} generic accepting time series
objects of classes \code{ts} and \code{xts} as data argument.
}
}
\section{Acknowledgements}{
 We thank Kamil Slowikowski not only for
  contributing ideas and code examples to this package but also for adding
  new features to his package 'ggrepel' that allow new use cases for
  \code{stat_dens2d_labels()}, \code{position_nudge_center()},
  \code{position_nudge_line()} and \code{position_nudge_to()} from this
  package. This package includes code copied and/or modified from
  that in package 'ggplot2'.
}

\references{
Package 'ggplot2' documentation is available at
\url{https://ggplot2.tidyverse.org/}\cr Package 'ggplot2' source code at
\url{https://github.com/tidyverse/ggplot2}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://docs.r4photobiology.info/ggpp/}
  \item \url{https://github.com/aphalo/ggpp}
  \item Report bugs at \url{https://github.com/aphalo/ggpp/issues}
}

}
\author{
\strong{Maintainer}: Pedro J. Aphalo \email{pedro.aphalo@helsinki.fi} (\href{https://orcid.org/0000-0003-3385-972X}{ORCID})

Other contributors:
\itemize{
  \item Kamil Slowikowski (\href{https://orcid.org/0000-0002-2843-6370}{ORCID}) [contributor]
  \item Michał Krassowski (\href{https://orcid.org/0000-0002-9638-7785}{ORCID}) [contributor]
  \item Daniel Sabanés Bové (\href{https://orcid.org/0000-0002-0176-9239}{ORCID}) [contributor]
  \item Stella Banjo [contributor]
}

}
