% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{energy_data}
\alias{energy_data}
\title{Energy Production Projection Data}
\format{
A data frame with 24 rows and 7 variables:
\describe{
  \item{Year}{Integer year of projection (2025-2050)}
  \item{Scenario}{Character: High, Low, Moderate, Reference}
  \item{Biomass}{Numeric biomass energy proportion}
  \item{Coal}{Numeric coal energy proportion}
  \item{Electrolysis}{Numeric electrolysis energy proportion}
  \item{Gas}{Numeric gas energy proportion}
  \item{Nuclear}{Numeric nuclear energy proportion}
}
}
\source{
Data simulated from:\cr
Ampah, J.D., Jin, C., Liu, H. et al. (2024) "Deployment expectations
of multi-gigatonne scale carbon removal could have adverse impacts on
Asia’s energy-water-land nexus" <doi:10.1038/s41467-024-50594-5>
}
\usage{
data(energy_data)
}
\description{
A dataset containing projected energy production values under different
scenarios from 2025 to 2050. The data includes projections for various
energy sources.
}
\keyword{datasets}
