% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_interactive.R
\name{geom_image_interactive}
\alias{geom_image_interactive}
\title{Create interactive image of ggimage}
\usage{
geom_image_interactive(...)
}
\arguments{
\item{...}{see also the parameters of \code{geom_image()} of \code{ggimage}}
}
\description{
The geometry is based on \code{geom_image()}.
See the documentation for those functions for more details.
}
\examples{
\dontrun{
library("ggplot2")
library("ggimage")
library("ggiraph")
set.seed(2017-02-21)
d <- data.frame(x = rnorm(10),
                y = rnorm(10),
                image = sample(c("https://www.r-project.org/logo/Rlogo.png",
                                "https://jeroenooms.github.io/images/frink.png"),
                              size=10, replace = TRUE)
               )
d$id <- sample(10)
p <- ggplot(d, aes(x, y)) + 
     geom_image_interactive(aes(image=image, tooltip = id, data_id = id))
girafe(ggobj = p)
}
}
