% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_size_tile.R
\name{scale_size_tile}
\alias{scale_size_tile}
\alias{scale_size_binned_tile}
\title{Scales for area or radius of bin tiles}
\usage{
scale_size_tile(
  name = ggplot2::waiver(),
  ...,
  max_size = 1,
  oob = scales::squish
)

scale_size_binned_tile(
  name = ggplot2::waiver(),
  ...,
  max_size = 1,
  oob = scales::squish
)
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{...}{Arguments passed on to \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}} or
\code{\link[ggplot2:binned_scale]{ggplot2::binned_scale()}}.}

\item{max_size}{Size of largest points.}

\item{oob}{One of:
\itemize{
\item Function that handles limits outside of the scale limits
(out of bounds). Also accepts rlang \link[rlang:as_function]{lambda}
function notation.
\item The default (\code{\link[scales:oob]{scales::squish()}}) squishes out of bounds values into range.
\item \code{\link[scales:oob]{scales::censor()}} for replacing out of bounds values with \code{NA}.
\item \code{\link[scales:oob]{scales::squish_infinite()}} for squishing infinite values into range.
}}
}
\value{
A \code{\link[ggplot2:ggplot2-ggproto]{ggplot2::Scale}}.
}
\description{
Replacements for \code{\link[ggplot2:scale_size]{ggplot2::scale_size_area()}} and
\code{\link[ggplot2:scale_size]{ggplot2::scale_size_binned_area()}} with convenient defaults for
\code{\link[=geom_hextile]{geom_hextile()}}.
}
\details{
These are convenience functions with the following changed defaults:
\itemize{
\item \code{max_size = 1} rather than \code{6},
\item \code{oob = scales::squish}.
}

In practice, this makes it easy to set a hard upper limit on a scale,
above which sizes are clamped to 1.
}
\examples{
library(ggplot2)

d <- ggplot(diamonds, aes(carat, depth, z = price)) +
  geom_hextile()
d + scale_size_tile(limits = c(NA, 100))

d + scale_size_binned_tile(transform = "log10")

}
