% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend_style.R
\name{center_legend_title}
\alias{center_legend_title}
\title{Center Legend Title Over Keys}
\usage{
center_legend_title(plot, position = "all")
}
\arguments{
\item{plot}{A ggplot object.}

\item{position}{Legend position to modify. One of \code{"right"}, \code{"left"},
\code{"top"}, \code{"bottom"}, or \code{"all"} (default).}
}
\value{
A modified gtable object that can be drawn with \code{grid::grid.draw()}
or saved with \code{ggplot2::ggsave()}.
}
\description{
Modifies a ggplot so that legend titles are centered over the key column
only, rather than over the full legend width (keys + labels). This is
particularly useful when legend labels are rotated, as the default centering
places the title too far to the right.
}
\details{
This function works by modifying the legend's internal gtable structure,
restricting the title's column span to only the keys column. Long titles
will automatically wrap to fit within the key column width, and proper
spacing is added to prevent overlap with rotated labels.

The title should have \code{hjust = 0.5} set (done automatically by
\code{legend_style(angle = ...)}) for proper centering.
}
\examples{
library(ggplot2)

p <- ggplot(mpg, aes(displ, hwy, color = class)) +
  geom_point() +
  legend_style(angle = 45) +
  labs(color = "Vehicle Class")

# Center title over keys only (long titles wrap automatically)
# Returns a gtable - use grid::grid.draw() to render
g <- center_legend_title(p)
grid::grid.draw(g)

}
\seealso{
\code{\link{legend_style}}
}
