% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pythagoras.r
\name{pythagoras}
\alias{pythagoras}
\title{A helper function to calculate vector lengths}
\usage{
pythagoras(x, y)
}
\arguments{
\item{x}{A \code{numeric} \code{vector} with the same length as \code{y}. It should
represent the lengths of the first leg (cathetus) of right triangles.}

\item{y}{A \code{numeric} \code{vector} with the same length as \code{x}. It should
represent the lengths of the second leg (cathetus) of right triangles.}
}
\value{
Returns a \code{numeric} \code{vector} with the same length as \code{x} and \code{y},
reflecting the lengths of the hypotenuse of the right triangles.
}
\description{
Calculates the length of a vector using the Pythagorean theorem.
}
\examples{
pythagoras(x = c(1, 2), y = c(1, 2))
}
\author{
Pepijn de Vries
}
