% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gge.R
\name{gge}
\alias{gge}
\alias{gge-package}
\alias{gge.data.frame}
\alias{gge.formula}
\alias{gge.matrix}
\alias{plot.gge}
\alias{biplot.gge}
\alias{biplot3d}
\alias{biplot3d.gge}
\title{GGE and GGB biplots}
\usage{
gge(x, ...)

\method{gge}{data.frame}(x, formula, gen.group = NULL, env.group = NULL, ggb = FALSE, ...)

\method{gge}{formula}(formula, data, gen.group = NULL, env.group = NULL, ggb = FALSE, ...)

\method{gge}{matrix}(
  x,
  center = TRUE,
  scale = TRUE,
  gen.group = NULL,
  env.group = NULL,
  ggb = FALSE,
  comps = c(1, 2),
  method = "svd",
  ...
)

\method{plot}{gge}(x, main = substitute(x), ...)

\method{biplot}{gge}(
  x,
  main = substitute(x),
  subtitle = "",
  xlab = "auto",
  ylab = "auto",
  cex.gen = 0.6,
  cex.env = 0.5,
  col.gen = "darkgreen",
  col.env = "orange3",
  pch.gen = 1,
  lab.env = TRUE,
  comps = 1:2,
  flip = "auto",
  origin = "auto",
  res.vec = TRUE,
  hull = FALSE,
  zoom.gen = 1,
  zoom.env = 1,
  ...
)

biplot3d(x, ...)

\method{biplot3d}{gge}(
  x,
  cex.gen = 0.6,
  cex.env = 0.5,
  col.gen = "darkgreen",
  col.env = "orange3",
  comps = 1:3,
  lab.env = TRUE,
  res.vec = TRUE,
  zoom.gen = 1,
  ...
)
}
\arguments{
\item{x}{A matrix or data.frame.}

\item{...}{Other arguments (e.g. maxiter, gramschmidt)}

\item{formula}{A formula}

\item{gen.group}{genotype group}

\item{env.group}{env group}

\item{ggb}{If TRUE, fit a GGB biplot model.}

\item{data}{Data frame}

\item{center}{If TRUE, center values for each environment}

\item{scale}{If TRUE, scale values for each environment}

\item{comps}{Principal components to use for the biplot. Default c(1,2).}

\item{method}{method used to find principal component directions. Either
"svd" or "nipals".}

\item{main}{Title, by default the name of the data. Use NULL to suppress the title.}

\item{subtitle}{Subtitle to put in front of options. Use NULL to suppress the subtitle.}

\item{xlab}{Label along axis. Default "auto" shows percent of variation explained. Use NULL to suppress.}

\item{ylab}{Label along axis. Default "auto" shows percent of variation explained. Use NULL to suppress.}

\item{cex.gen}{Character expansion for genotype labels, default 0.6. Use 0 to omit genotype labels.}

\item{cex.env}{Character expansion for environment labels/symbols.  Use lab.env=FALSE to omit labels.}

\item{col.gen}{Color for genotype labels.  May be a single color for all genotypes,
or a vector of colors for each genotype.}

\item{col.env}{Color for environments. May be a single color for all environments,
or a vector of colors for each environment.}

\item{pch.gen}{Plot character for genotypes}

\item{lab.env}{Label environments if TRUE.}

\item{flip}{If "auto" then each axis is flipped so that the genotype
ordinate is positively correlated with genotype means.  Can also be
a vector like c(TRUE,FALSE) for manual control.}

\item{origin}{If "auto", the plotting window is centered on genotypes, otherwise
the origin is at the middle of the window.}

\item{res.vec}{If TRUE, for each group, draw residual vectors from the mean
of the locs to the individual locs.}

\item{hull}{If TRUE, show a which-won-where polygon.}

\item{zoom.gen}{Zoom factor for manual control of genotype xlim,ylim
The default is 1. Values less than 1 may be useful if genotype names are long.}

\item{zoom.env}{Zoom factor for manual control of environment xlim,ylim.
The default is 1. Values less than 1 may be useful if environment names are long.
Not used for 3D biplots.}
}
\value{
A list of class \code{gge} containing:
\item{x}{The filled-in data}
\item{x.orig}{The original data}
\item{genCoord}{genotype coordinates}
\item{locCoord}{loc coordinates}
\item{blockCoord}{block coordinates}
\item{gen.group}{If not NULL, use this to specify a column of the
  data.frame to classify genotypes into groups.}
\item{env.group}{If not NULL, use this to specify a column of the
  data.frame to classify environments into groups.}
\item{ggb}{If TRUE, create a GGB biplot}
\item{genMeans}{genotype means}
\item{mosdat}{mosaic plot data}
\item{R2}{variation explained by each PC}
\item{center}{Data centered?}
\item{scale}{Data scaled?}
\item{method}{Method used to calculate principal components.}
\item{pctMiss}{Percent of x that is missing values}
\item{maxPCs}{Maximum number of PCs}
}
\description{
Fit a GGE (genotype + genotype * environment) model and display the results.
}
\details{
If there is replication in G*E, then the replications are averaged together
before constructing the biplot.

The singular value decomposition of \code{x} is used to calculate the
principal components for the biplot.  Missing values are NOT allowed.

The argument \code{method} can be either
'svd' for complete-data or 'nipals' for missing-data.
}
\examples{
# Example 1.  Data is a data.frame in 'matrix' format
B <- matrix(c(50, 67, 90, 98, 120,
              55, 71, 93, 102, 129,
              65, 76, 95, 105, 134,
              50, 80, 102, 130, 138,
              60, 82, 97, 135, 151,
              65, 89, 106, 137, 153,
              75, 95, 117, 133, 155), ncol=5, byrow=TRUE)
rownames(B) <- c("G1","G2","G3","G4","G5","G6","G7")
colnames(B) <- c("E1","E2","E3","E4","E5")

library(gge)
m1 = gge(B)
plot(m1)
biplot(m1, main="Example biplot")
# biplot3d(m1)

if(require(agridat)){
  # crossa.wheat biplot

  # Specify env.group as column in data frame
  data(crossa.wheat)
  dat2 <- crossa.wheat
  m2 <- gge(dat2, yield~gen*loc, env.group=locgroup, scale=FALSE)
  plot(m2)
  biplot(m2, lab.env=TRUE, main="crossa.wheat")
  # biplot3d(m2)
}

}
\references{
Jean-Louis Laffont, Kevin Wright and Mohamed Hanafi (2013).
Genotype + Genotype x Block of Environments (GGB) Biplots.
\emph{Crop Science}, 53, 2332-2341.
\doi{10.2135/cropsci2013.03.0178}.

Kroonenberg, Pieter M. (1997).
\emph{Introduction to Biplots for GxE Tables},
Research Report 51, Centre for Statistics, The University of Queensland,
Brisbane, Australia.
\url{https://three-mode.leidenuniv.nl/document/biplot.pdf}

Yan, W. and Kang, M.S. (2003).
\emph{GGE Biplot Analysis}.  CRC Press.
}
\author{
Kevin Wright, Jean-Louis Laffont

Jean-Louis Laffont, Kevin Wright
}
