% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscale.R
\name{subscale_identity}
\alias{subscale_identity}
\title{Identity sub-scale for thickness aesthetic}
\usage{
subscale_identity(x)
}
\arguments{
\item{x}{<\link{numeric}> Vector to be rescaled.
Typically provided automatically by \code{\link[=geom_slabinterval]{geom_slabinterval()}}.}
}
\value{
A \link{thickness} vector of the same length as \code{x}, with infinite
values in \code{x} squished into the data range.
}
\description{
This is an identity sub-scale for the \code{thickness} aesthetic
in \pkg{ggdist}. It returns its input as a \link{thickness} vector without
rescaling. It can be used with the \code{subscale} parameter of
\code{\link[=geom_slabinterval]{geom_slabinterval()}}.
}
\seealso{
Other sub-scales: 
\code{\link{subscale_thickness}()}
}
\concept{sub-scales}
