% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggparallel.R
\name{ggparallel}
\alias{ggparallel}
\title{Parallel Coordinate Plots}
\usage{
ggparallel(
  data,
  col_id = NULL,
  col_colour = NULL,
  highlight = NULL,
  interactive = TRUE,
  order_columns_by = c("appearance", "random", "auto"),
  order_observations_by = c("frequency", "original"),
  verbose = TRUE,
  palette_colour = palette.colors(palette = "Set2"),
  palette_highlight = c("red", "grey90"),
  convert_binary_numeric_to_factor = TRUE,
  scaling = c("uniminmax", "none"),
  return = c("plot", "data"),
  options = ggparallel_options()
)
}
\arguments{
\item{data}{A data frame containing the variables to plot.}

\item{col_id}{The name of the column to use as an identifier. If \code{NULL}, artificial IDs will be generated based on row numbers. (character)}

\item{col_colour}{Name of the column to use for coloring lines in the plot. If \code{NULL}, no coloring is applied. (character)}

\item{highlight}{A level from \code{col_colour} to emphasize in the plot. Ignored if \code{col_colour} is not set. (character)}

\item{interactive}{Produce interactive ggiraph visualiastion (flag)}

\item{order_columns_by}{Strategy for ordering columns in the plot. Options include:
\itemize{
\item \strong{"appearance"}: Order columns by their order in \code{data} (default).
\item \strong{"random"}: Randomly order columns.
\item \strong{"auto"}: Automatically order columns based on context:
\itemize{
\item If \code{highlight} is set, columns are ordered to maximize separation between the highlighted level and all others, using mutual information.
\item If \code{col_colour} is set but \code{highlight} is not, columns are ordered based on mutual information with all classes in \code{col_colour}.
\item If neither \code{highlight} nor \code{col_colour} is set, columns are ordered to minimize the estimated number of crossings, using a repetitive nearest neighbour approach with two-opt refinement.
}
}}

\item{order_observations_by}{Strategy for ordering lines in the plot. Options include:
\itemize{
\item \strong{"frequency"}: Draw the largest groups first.
\item \strong{"original"}: Preserve the original order in \code{data}.
} Ignored if \code{highlight} is set.}

\item{verbose}{Logical; whether to display informative messages during execution. (default: \code{TRUE})}

\item{palette_colour}{A named vector of colors for categorical levels in \code{col_colour}. (default: Set2 palette)}

\item{palette_highlight}{A two-color vector for highlighting (\code{highlight} and others). (default: \code{c("red", "grey90")})}

\item{convert_binary_numeric_to_factor}{Logical; whether to convert numeric columns containing only 0, 1, and NA to factors. (default: \code{TRUE})}

\item{scaling}{Method for scaling numeric variables. Options include:
\itemize{
\item \strong{"uniminmax"}: Rescale each variable to range [0, 1].
\item \strong{"none"}: No rescaling. Use raw values.
}}

\item{return}{What to return. Options include:
\itemize{
\item \strong{"plot"}: Return the ggplot object (default).
\item \strong{"data"}: Return the processed data used for plotting.
}}

\item{options}{A list of additional visualization parameters created by \code{ggparallel_options()}.}
}
\value{
A ggplot object or a processed data frame, depending on the \code{return} parameter.
}
\description{
Visualize relationships between numeric variables and categorical groupings
using parallel coordinate plots.
}
\examples{
ggparallel(
  data = minibeans,
  col_colour = "Class",
  order_columns_by = "auto"
)

ggparallel(
  data = minibeans,
  col_colour = "Class",
  highlight = "DERMASON",
  order_columns_by = "auto"
)

# Customise appearance using options argument
ggparallel(
  data = minibeans,
  col_colour = "Class",
  order_columns_by = "auto",
  options = ggparallel_options(show_legend = FALSE)
)

}
