% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_prediction.R
\name{fit_tte_data_prior}
\alias{fit_tte_data_prior}
\title{Fit Weibull survival curves to patient-level time-to-event data by including patient-level weighted prior data}
\usage{
fit_tte_data_prior(
  data,
  Time = "Time",
  Event = "Event",
  censoringOne = FALSE,
  type = c("Weibull"),
  priordata,
  priorTime = Time,
  priorEvent = Event,
  priorcensoringOne = censoringOne,
  priorweight = 1,
  init = NULL
)
}
\arguments{
\item{data}{The dataframe object containing the patient-level survival data}

\item{Time}{The column name for the times. Default is "Time"}

\item{Event}{The column name for the events column (i.e. the binary variable denoting events vs censorings). Default is "Event"}

\item{censoringOne}{Specify whether censoring is denoted in the Event column by a one (TRUE) or zero (FALSE). Default=FALSE (censorings denoted by 0, events by 1)}

\item{type}{Type of event curve to fit. Default is "Weibull", the only type currently accepted}

\item{priordata}{The dataframe object containing a patient-level prior dataset.
Where a patient-level prior data set is not readily available, the function create_tte_prior can be used to create one from summary parameters.
Naming and format of time and event columns should match that of 'data'. Default=NULL (no prior data)}

\item{priorTime}{The column name for the prior times. Default is the same value as Time}

\item{priorEvent}{The column name for the prior events (i.e. the binary variable denoting events vs censorings). Default is the same value as Event}

\item{priorcensoringOne}{Specify whether censoring is denoted in the prior Event column by a one (TRUE) or zero (FALSE). Default is the same as censoringOne}

\item{priorweight}{The weight to assign the prior data; a non-negative number, where 0 corresponds to no weight, i.e. ignore prior data, and 1 corresponds to equal
weighting of prior and observed data.
The prior weight should typically not be greater than 1. Default=1 (prior patients weighted equivalently to observed data)}

\item{init}{Vector of starting values for parameter values; useful if survreg experiences convergence issues. Default=NULL (no values specified)}
}
\value{
Returns a 3-item list providing information needed to define a Curve object:
\itemize{
 \item{"Item 1"}{The type of Curve object fitted.}
 \item{"Item 2"}{A list of fitted parameters for the curve type.}
 \item{"Item 3"}{A vector containing the covariance-matrix parameters for the curve type.}
 \item{"Item 4"}{A data frame containing the goodness of fit metrics for each curve type.}
}
}
\description{
This is a function to fit Weibull curves to patient-level Survival data integrating (weighted) prior data.\cr
Where relevant prior data is available, this function can increase the precision of curve fitting, particularly in cases where there is low data maturity.\cr
}
\details{
This function is primarily used by the event_prediction_prior function, but also useful for Weibull curve fitting across two patient-level data sets.\cr
If a patient-level prior data set is not available, use the create_tte_prior function to create an artificial one from a distribution.
Note that this may cause a small amount of over-precision; this may be minimised by deriving the prior data using a different distribution or specifying down-weighting.\cr
}
\examples{
recruit <- PieceR(matrix(c(rep(1,12),10,15,25,30,45,60,55,50,65,60,55,30),ncol=2),1)
example_data <- simulate_trials(active_ecurve=Weibull(50,0.8),control_ecurve=Weibull(50,0.8),
rcurve=recruit, assess=10,iterations=1,seed=12345,detailed_output=TRUE,Event="Event",
censoringOne=FALSE)
example_prior <- create_tte_prior(curve=Weibull(alpha=100,beta=0.8),duration=20,events=50)

fit_tte_data_prior(data=example_data,priordata=example_prior,priorweight=0.5)
}
\references{
Bell J, unpublished work.
D Fink, A Compendium of Conjugate Priors, 1997
}
\author{
James Bell
}
