% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_prediction.R
\name{event_prediction_prior}
\alias{event_prediction_prior}
\title{Event prediction using patient-level survival data, prior data and a recruitment RCurve}
\usage{
event_prediction_prior(
  data,
  Time = "Time",
  Event = "Event",
  censoringOne = FALSE,
  priordata,
  priorTime = Time,
  priorEvent = Event,
  priorcensoringOne = censoringOne,
  priorweight = 1,
  type = c("Weibull"),
  rcurve,
  max_time = 100,
  dcurve = Blank(),
  CI = NULL,
  PI = 0.95,
  condition = NULL,
  cond_Events = NULL,
  cond_NatRisk = NULL,
  cond_Time = NULL,
  units = c("Days", "Months"),
  init = NULL,
  discountHR = 1
)
}
\arguments{
\item{data}{The dataframe object containing the patient-level survival data}

\item{Time}{The column name for the times in the 'data' set. Default is "Time"}

\item{Event}{The column name for the events column (i.e. the binary variable denoting events vs censorings) in the 'data' set. Default is "Event"}

\item{censoringOne}{Specify whether in the 'data' set censoring is denoted by a one (TRUE) or zero (FALSE). Default=FALSE (censorings denoted by 0, events by 1)}

\item{priordata}{The dataframe object containing the patient-level survival data for the prior}

\item{priorTime}{The column name for the times in the 'priordata' set. Default= Value specified for Time}

\item{priorEvent}{The column name for the events column (i.e. the binary variable denoting events vs censorings) in the 'priordata' set. Default= Value specified for Event}

\item{priorcensoringOne}{Specify whether in the 'priordata' set censoring is denoted by a one (TRUE) or zero (FALSE). Default= Value specified for censoringOne}

\item{priorweight}{The weight that should be allocated to each patient's data in the prior data, typically between 0 and 1. 0 implies prior data is ignored, 1 that prior patient data is given full weight, i.e. prior patients are exchangeable with observed patients. Default = 1}

\item{type}{Type of event curve to fit. Default is "Automatic", fitting both Weibull and Log-normal curves.
Alternatively accepts "Weibull", "Lognormal" or "Exponential" to force the type.}

\item{rcurve}{Observed and/or expected recruitment distribution as an RCurve object. This should typically be of PieceR type (piecewise linear recruitment).}

\item{max_time}{Maximum time to predict events up to.}

\item{dcurve}{Dropout/censoring distribution as a Curve object. This is Blank() by default, i.e. no dropout.}

\item{CI}{DEPRECATED As of version 1.4.0 this argument has been renamed to 'PI'.}

\item{PI}{Number between 0 and 1 for the size of prediction interval to calculate. As of 1.4.0 this replaces the 'CI' argument. Default is 0.95 (95 percent prediction interval).}

\item{condition}{DEPRECATED This argument has been removed as of version 1.4.0. Specifying a value for 'cond_Events' will now enable conditioned predictions.}

\item{cond_Events}{Number of observed events at the conditioning time to condition on. If NULL, no conditioned event prediction will be performed. Default=NULL (no conditioning).
Note that if the discountHR option is used to predict adjusted event numbers, it would be possible to condition on either observed or adjusted events, but the observed number is required by this function.}

\item{cond_NatRisk}{Number of patients at risk to condition on. Default=NULL.
By default, the program will estimate the number at risk assuming no censoring. It is highly recommended to specify this if conditioning.}

\item{cond_Time}{Time, in months, to condition on. A non-negative integer less than max_time is required if conditioning is requested, i.e. cond_Events is non-NULL. Not required otherwise.}

\item{units}{Units that the KM-curve is specified in. Accepts "Days", "Months". Default="Days".}

\item{init}{Vector of starting values for parameter values; useful if survreg experiences convergence issues. Default=NULL (no values specified)}

\item{discountHR}{Hazard ratio for discounting events e.g. used to predict adjudicated events from unadjudicated data where patients remain 'at risk' after an event is adjudicated not to have occurred.
Values below 1 indicate fewer events will occur than predicted by the curve-fitting.
When a discountHR is user-specified (i.e. not 1), conditioning event numbers need to be specified in terms of observed values, and not adjusted ones.
Note that changing this argument is only allowed if type="Weibull" since log-normal curves are not compatible with proportional hazards.
If patients become not at risk following a failed adjudication (i.e. removed from study), do not use this argument and instead adjust the output event numbers by the required factor.
Default=1 (No discounting for adjudication)}
}
\value{
Returns a list object with the prediction ecurve (after adjustments for unit, discountHR), dcurve, rcurve, required PI, original fitted ecurve parameters (before adjustments)
    and a summary table with one row per month up to max_time containing the following columns:
\itemize{
 \item{"Assessment_Time"}{Time of assessment.}
 \item{"Patients"}{Number of patients recruited by the assessment time.}
 \item{"Predicted_Events"}{Number of events unconditionally predicted at the assessment time.}
 \item{"SE_Fitting"}{SE of the estimate of the fitted mean. Note that this corresponds to the accuracy of the estimate of the underlying parameter, not future observed event numbers.}
 \item{"SE_Prediction"}{SE of event prediction.}
 \item{"Prediction_Lower"}{Lower bound of X percent interval of unconditional event prediction, where X is the 'PI' argument. This PI is based on the quantiles of the beta-binomial distribution and so is discrete and asymmetric.}
 \item{"Prediction_Upper"}{Upper bound of X percent interval of unconditional event prediction, where X is the 'PI' argument. This PI is based on the quantiles of the beta-binomial distribution and so is discrete and asymmetric.}
 \item{"Conditioned_Events"}{Number of events conditionally predicted at the assessment time (Column present only if conditioning specified).}
 \item{"Cond_SE_Fitting"}{SE of the estimate of the fitted conditional mean. Note that this corresponds to the accuracy of the estimate of the underlying parameter, not future observed event numbers (Column present only if conditioning specified).}
 \item{"Cond_SE_Prediction"}{SE of the conditional event prediction (Column present only if conditioning specified).}
 \item{"Cond_Prediction_Lower"}{Lower bound of X percent interval of conditional event prediction, where X is the 'PI' argument. This PI is based on the quantiles of the beta-binomial distribution and so is discrete and asymmetric.}
 \item{"Cond_Prediction_Upper"}{Upper bound of X percent interval of conditional event prediction, where X is the 'PI' argument. This PI is based on the quantiles of the beta-binomial distribution and so is discrete and asymmetric.}
}
}
\description{
This performs event prediction with a Weibull distribution integrating (weighted) prior data .\cr
Where relevant prior data is available, this function can increase the precision of curve fitting, particularly in cases where there is low data maturity.\cr
This function uses the fit_tte_data_prior function to fit a Weibull distribution to the provided survival data by including weighted prior patient-level data.\cr
An event Curve object is created, which is then used in the same way as that from the frequentist approach in event_prediction.\cr
It consequently operates very similarly to event_prediction in terms of inputs, outputs and methods. Consult its documentation for aspects unrelated to the prior approach.\cr
If a patient-level prior data set is not available, use the create_tte_prior function to create an artificial one from a distribution.
Note that this may cause a small amount of over-precision; this may be minimised by deriving the prior data using a different distribution or specifying down-weighting.\cr
Prior data can be down-weighted using the priorweight variable. Some degree of down-weighting is generally recommended to reflect differences with prior trials.\cr
Column names and the censoring parity in the prior data set are by default the same as those specified for the main data set, but may be manually changed to be different.\cr
}
\examples{
recruit <- PieceR(matrix(c(rep(1,12),10,15,25,30,45,60,55,50,65,60,55,30),ncol=2),1)
trial_short <- simulate_trials(active_ecurve=Weibull(50,0.8),control_ecurve=Weibull(50,0.8),
rcurve=recruit, assess=10,iterations=1,seed=12345,detailed_output=TRUE,Event="Event",
censoringOne=FALSE)
example_prior <- create_tte_prior(curve=Weibull(alpha=100,beta=0.8),duration=20,events=50)

predictions <- event_prediction_prior(data=trial_short, priordata=example_prior,
type="Weibull", rcurve=recruit, max_time=60, cond_Events=49, cond_NatRisk=451,
cond_Time=10, units="Months")
}
\references{
Bell J, unpublished work.
}
\author{
James Bell
}
