#' Upper Continental Crust
#'
#' A data set containing the composition of the _Upper Continental Crust_ as
#' recommended by \insertCite{Rudnick2014;textual}{georefdatar}. This article is
#' a revision of the previous work \insertCite{Rudnick2003;textual}{georefdatar}.
#'
#' In this work the concentrations of the major elements (as oxides) are given
#' in wt%. The concentrations of all other elements are given in ug/g (ppm) or
#' ng/g (ppb). For the sake of unity the values given in ppb where converted
#' to ppm using `ppm= ppb/1000`.\cr
#' The listed values for the major elements (oxides) are in wt% and all other
#' elements are given in ppm. Heat production is given in mW/m^3.
#'
#' @format A data frame with 1 row and `r ncol(CC_Upper__Rudnick_Gao__2014)` element concentrations. These elements are:\cr
#' `r paste(colnames(CC_Upper__Rudnick_Gao__2014), collapse= ', ')`
#'
#'
#'
#' @references
#' \insertRef{Rudnick2014}{georefdatar}
#'
#' \insertRef{Rudnick2003}{georefdatar}
#'
#'
#' @importFrom Rdpack reprompt
"CC_Upper__Rudnick_Gao__2014"


#' Middle Continental Crust
#'
#' A data set containing the composition of the _Middle Continental Crust_ as
#' recommended by \insertCite{Rudnick2014;textual}{georefdatar}. This article is
#' a revision of the previous work \insertCite{Rudnick2003;textual}{georefdatar}.
#'
#' In this work the concentrations of the major elements (as oxides) are given
#' in wt%. The concentrations of all other elements are given in ug/g (ppm) or
#' ng/g (ppb). For the sake of unity the values given in ppb where converted
#' to ppm using `ppm= ppb/1000`.\cr
#' The listed values for the major elements (oxides) are in wt% and all other
#' elements are given in ppm. Heat production is given in mW/m^3.
#'
#' @format A data frame with 1 row and `r ncol(CC_Middle__Rudnick_Gao__2014)` element concentrations. These elements are:\cr
#' `r paste(colnames(CC_Middle__Rudnick_Gao__2014), collapse= ', ')`
#'
#'
#'
#' @references{
#'   \insertRef{Rudnick2014}{georefdatar}
#'   \insertRef{Rudnick2003}{georefdatar}
#' }
#'
#' @importFrom Rdpack reprompt
"CC_Middle__Rudnick_Gao__2014"


#' Lower Continental Crust
#'
#' A data set containing the composition of the _Lower Continental Crust_ as
#' recommended by \insertCite{Rudnick2014;textual}{georefdatar}. This article is
#' a revision of the previous work \insertCite{Rudnick2003;textual}{georefdatar}.
#'
#' In this work the concentrations of the major elements (as oxides) are given
#' in wt%. The concentrations of all other elements are given in ug/g (ppm) or
#' ng/g (ppb). For the sake of unity the values given in ppb where converted
#' to ppm using `ppm= ppb/1000`.\cr
#' The listed values for the major elements (oxides) are in wt% and all other
#' elements are given in ppm. Heat production is given in mW/m^3.
#'
#' @format A data frame with 1 row and `r ncol(CC_Lower__Rudnick_Gao__2014)` element concentrations. These elements are:\cr
#' `r paste(colnames(CC_Lower__Rudnick_Gao__2014), collapse= ', ')`
#'
#'
#'
#' @references{
#'   \insertRef{Rudnick2014}{georefdatar}
#'   \insertRef{Rudnick2003}{georefdatar}
#' }
#'
#' @importFrom Rdpack reprompt
"CC_Lower__Rudnick_Gao__2014"


#' Bulk Continental Crust
#'
#' A data set containing the composition of the _Bulk Continental Crust_ as
#' recommended by \insertCite{Rudnick2014;textual}{georefdatar}. This article is
#' a revision of the previous work \insertCite{Rudnick2003;textual}{georefdatar}.
#'
#' In this work the concentrations of the major elements (as oxides) are given
#' in wt%. The concentrations of all other elements are given in ug/g (ppm) or
#' ng/g (ppb). For the sake of unity the values given in ppb where converted
#' to ppm using `ppm= ppb/1000`.\cr
#' The listed values for the major elements (oxides) are in wt% and all other
#' elements are given in ppm. Heat production is given in mW/m^3.
#'
#' @format A data frame with 1 row and `r ncol(CC_Bulk__Rudnick_Gao__2014)` element concentrations. These elements are:\cr
#' `r paste(colnames(CC_Bulk__Rudnick_Gao__2014), collapse= ', ')`
#'
#'
#'
#' @references{
#'   \insertRef{Rudnick2014}{georefdatar}
#'   \insertRef{Rudnick2003}{georefdatar}
#' }
#'
#' @importFrom Rdpack reprompt
"CC_Bulk__Rudnick_Gao__2014"
