% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multistar.R
\name{multistar_as_flat_table}
\alias{multistar_as_flat_table}
\alias{multistar_as_flat_table.multistar}
\title{Export a \code{multistar} as a flat table}
\usage{
multistar_as_flat_table(ms, fact = NULL)

\method{multistar_as_flat_table}{multistar}(ms, fact = NULL)
}
\arguments{
\item{ms}{A \code{multistar} object.}

\item{fact}{A string, name of the fact.}
}
\value{
A \code{tibble}.
}
\description{
We can obtain a flat table, implemented using a \code{tibble}, from a \code{multistar}
(which can be the result of a query). If it only has one fact table, it is
not necessary to provide its name.
}
\examples{

ft <- ms_mrs |>
  multistar_as_flat_table(fact = "mrs_age")

ms <- dimensional_query(ms_mrs) |>
  select_dimension(name = "where",
                   attributes = c("city", "state")) |>
  select_dimension(name = "when",
                   attributes = c("when_happened_year")) |>
  select_fact(name = "mrs_age",
              measures = c("n_deaths")) |>
  select_fact(
    name = "mrs_cause",
    measures = c("pneumonia_and_influenza_deaths", "other_deaths")
  ) |>
  filter_dimension(name = "when", when_happened_week <= "03") |>
  filter_dimension(name = "where", city == "Boston") |>
  run_query()

ft <- ms |>
  multistar_as_flat_table()

}
\concept{results export functions}
