% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOFeatureCatalogue.R
\docType{class}
\name{ISOFeatureCatalogue}
\alias{ISOFeatureCatalogue}
\title{ISOFeatureCatalogue}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ISO FeatureCatalogue
}
\description{
ISOFeatureCatalogue

ISOFeatureCatalogue
}
\examples{
 fc <- ISOFeatureCatalogue$new(uuid = "my-fc-identifier")
 fc$setName("name")
 fc$addScope("scope1")
 fc$addScope("scope2")
 fc$addFieldOfApplication("field1")
 fc$addFieldOfApplication("field2")
 fc$setVersionNumber("1.0")
 fc$setVersionDate(ISOdate(2015, 1, 1, 1))
 
 producer <- ISOResponsibleParty$new()
 producer$setIndividualName("someone")
 fc$setProducer(producer)
 fc$setFunctionalLanguage("eng")
 
 cit <- ISOCitation$new()
 cit$setTitle("some citation title")
 fc$addDefinitionSource(cit)
 #'  #add featureType
 ft <- ISOFeatureType$new()
 ft$setTypeName("typeName")
 ft$setDefinition("definition")
 ft$setCode("code")
 ft$setIsAbstract(FALSE)
 ft$addAlias("alias1")
 ft$addAlias("alias2")
 
 #add feature attributes
 for(i in 1:3){
   #create attribute
   fat <- ISOFeatureAttribute$new()
   fat$setMemberName(sprintf("name \%s",i))
   fat$setDefinition(sprintf("definition \%s",i))
   fat$setCardinality(lower=1,upper=1)
   fat$setCode(sprintf("code \%s",i))
   
   gml <- GMLBaseUnit$new(id = sprintf("ID\%s",i))
   gml$setDescriptionReference("someref")
   gml$setIdentifier("identifier", "codespace")
   gml$addName("name1", "codespace")
   gml$addName("name2", "codespace")
   gml$setQuantityTypeReference("someref")
   gml$setCatalogSymbol("symbol")
   gml$setUnitsSystem("somelink")
   fat$setValueMeasurementUnit(gml)
   
   #add listed values
   val1 <- ISOListedValue$new()
   val1$setCode("code1")
   val1$setLabel("label1")
   val1$setDefinition("definition1")
   fat$addListedValue(val1)
   val2 <- ISOListedValue$new()
   val2$setCode("code2")
   val2$setLabel("label2")
   val2$setDefinition("definition2")
   fat$addListedValue(val2)
   fat$setValueType("typeName")
   
   #add feature attribute as carrierOfCharacteristic
   ft$addCharacteristic(fat)
 }
 #add featureType to catalogue
 fc$addFeatureType(ft)
 
 xml <- fc$encode()
 
}
\references{
ISO 19110:2005 Methodology for Feature cataloguing
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{catalogue}
\keyword{feature}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{\link[geometa:ISOAbstractCatalogue]{geometa::ISOAbstractCatalogue}} -> \code{ISOFeatureCatalogue}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attrs}}{attrs}

\item{\code{producer}}{producer [1..1]: ISOResponsibleParty}

\item{\code{functionalLanguage}}{functionalLanguage [0..1]: character}

\item{\code{featureType}}{featureType [1..*]: ISOFeatureType}

\item{\code{definitionSource}}{definitionSource [0..*]: ISODefinitionSource}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOFeatureCatalogue-new}{\code{ISOFeatureCatalogue$new()}}
\item \href{#method-ISOFeatureCatalogue-setProducer}{\code{ISOFeatureCatalogue$setProducer()}}
\item \href{#method-ISOFeatureCatalogue-setFunctionalLanguage}{\code{ISOFeatureCatalogue$setFunctionalLanguage()}}
\item \href{#method-ISOFeatureCatalogue-addFeatureType}{\code{ISOFeatureCatalogue$addFeatureType()}}
\item \href{#method-ISOFeatureCatalogue-delFeatureType}{\code{ISOFeatureCatalogue$delFeatureType()}}
\item \href{#method-ISOFeatureCatalogue-addDefinitionSource}{\code{ISOFeatureCatalogue$addDefinitionSource()}}
\item \href{#method-ISOFeatureCatalogue-delDefinitionSource}{\code{ISOFeatureCatalogue$delDefinitionSource()}}
\item \href{#method-ISOFeatureCatalogue-clone}{\code{ISOFeatureCatalogue$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="checkMetadataStandardCompliance"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-checkMetadataStandardCompliance'><code>geometa::ISOAbstractObject$checkMetadataStandardCompliance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="stopIfMetadataStandardIsNot"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-stopIfMetadataStandardIsNot'><code>geometa::ISOAbstractObject$stopIfMetadataStandardIsNot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="addFieldOfApplication"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-addFieldOfApplication'><code>geometa::ISOAbstractCatalogue$addFieldOfApplication()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="addLocale"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-addLocale'><code>geometa::ISOAbstractCatalogue$addLocale()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="addScope"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-addScope'><code>geometa::ISOAbstractCatalogue$addScope()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="addSubCatalogue"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-addSubCatalogue'><code>geometa::ISOAbstractCatalogue$addSubCatalogue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="delFieldOfApplication"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-delFieldOfApplication'><code>geometa::ISOAbstractCatalogue$delFieldOfApplication()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="delLocale"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-delLocale'><code>geometa::ISOAbstractCatalogue$delLocale()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="delScope"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-delScope'><code>geometa::ISOAbstractCatalogue$delScope()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="delSubCatalogue"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-delSubCatalogue'><code>geometa::ISOAbstractCatalogue$delSubCatalogue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="setCharacterSet"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-setCharacterSet'><code>geometa::ISOAbstractCatalogue$setCharacterSet()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="setLanguage"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-setLanguage'><code>geometa::ISOAbstractCatalogue$setLanguage()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="setName"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-setName'><code>geometa::ISOAbstractCatalogue$setName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="setVersionDate"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-setVersionDate'><code>geometa::ISOAbstractCatalogue$setVersionDate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractCatalogue" data-id="setVersionNumber"><a href='../../geometa/html/ISOAbstractCatalogue.html#method-ISOAbstractCatalogue-setVersionNumber'><code>geometa::ISOAbstractCatalogue$setVersionNumber()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureCatalogue-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureCatalogue-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureCatalogue$new(xml = NULL, uuid = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}

\item{\code{uuid}}{uuid}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureCatalogue-setProducer"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureCatalogue-setProducer}{}}}
\subsection{Method \code{setProducer()}}{
Set producer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureCatalogue$setProducer(producer)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{producer}}{object of class \link{ISOResponsibleParty} (in ISO 19139) or \link{ISOResponsibility} (in ISO 19115-3)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureCatalogue-setFunctionalLanguage"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureCatalogue-setFunctionalLanguage}{}}}
\subsection{Method \code{setFunctionalLanguage()}}{
Set functional language
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureCatalogue$setFunctionalLanguage(functionalLanguage)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{functionalLanguage}}{functional language}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureCatalogue-addFeatureType"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureCatalogue-addFeatureType}{}}}
\subsection{Method \code{addFeatureType()}}{
Adds feature type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureCatalogue$addFeatureType(featureType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{featureType}}{object of class \link{ISOFeatureType}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureCatalogue-delFeatureType"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureCatalogue-delFeatureType}{}}}
\subsection{Method \code{delFeatureType()}}{
Deletes feature type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureCatalogue$delFeatureType(featureType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{featureType}}{object of class \link{ISOFeatureType}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureCatalogue-addDefinitionSource"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureCatalogue-addDefinitionSource}{}}}
\subsection{Method \code{addDefinitionSource()}}{
Adds definition source
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureCatalogue$addDefinitionSource(source)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{object of class \link{ISODefinitionSource} or \link{ISOCitation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureCatalogue-delDefinitionSource"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureCatalogue-delDefinitionSource}{}}}
\subsection{Method \code{delDefinitionSource()}}{
Deletes definition source
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureCatalogue$delDefinitionSource(source)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{object of class \link{ISODefinitionSource} or \link{ISOCitation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOFeatureCatalogue-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOFeatureCatalogue-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOFeatureCatalogue$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
