% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seam.R
\name{seam_rip}
\alias{seam_rip}
\title{Remove Edges along a Boundary}
\usage{
seam_rip(adj, shp, admin, seam, epsg = 3857)
}
\arguments{
\item{adj}{zero indexed adjacency graph}

\item{shp}{tibble where admin column is found}

\item{admin}{quoted name of administrative unit column}

\item{seam}{units to rip the seam between by removing adjacency connections}

\item{epsg}{numeric EPSG code to planarize to. Default is 3857.}
}
\value{
adjacency list
}
\description{
Remove Edges along a Boundary
}
\examples{
data('rockland')
data('orange')
data('nrcsd')

o_and_r <- rbind(orange, rockland)
o_and_r <- o_and_r |>
  geo_filter(nrcsd) |>
  geo_trim(nrcsd)
adj <- adjacency(o_and_r)

seam_rip(adj, o_and_r, 'county', c('071', '087'))

}
\concept{seam}
