% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lewis.R
\name{get_lewis}
\alias{get_lewis}
\title{Get historical United States Congressional District Shapefiles}
\usage{
get_lewis(state, congress, path_only = FALSE)
}
\arguments{
\item{state}{two letter state abbreviation}

\item{congress}{congress number, from 1 to 114.}

\item{path_only}{logical. If TRUE, returns only the URL to the file.}
}
\value{
a sf tibble of the congressional district boundaries
}
\description{
Data sourced from the United States Congressional District Shapefiles, primarily
hosted at \url{https://cdmaps.polisci.ucla.edu/}. Files are fetched through the GitHub
repository at \url{https://github.com/JeffreyBLewis/congressional-district-boundaries}.
}
\examples{
path <- get_lewis(state = 'NM', congress = 111, path_only = TRUE)
if (attr(curlGetHeaders(path), 'status') == 200) {
  get_lewis(state = 'NM', congress = 111)
}
}
\references{
Jeffrey B. Lewis, Brandon DeVine, Lincoln Pitcher, and Kenneth C. Martis. (2013)
Digital Boundary Definitions of United States Congressional Districts, 1789-2012.
[Data file and code book]. Retrieved from \url{https://cdmaps.polisci.ucla.edu} on [date of download].
}
