% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centroid.R
\name{centroid}
\alias{centroid}
\title{Get centroid for a geo_list}
\usage{
centroid(x, ...)
}
\arguments{
\item{x}{An object of class geo_list}

\item{...}{Ignored}
}
\value{
A vector of the form longitude, latitude
}
\description{
Get centroid for a geo_list
}
\examples{
# numeric
vec <- c(-99.74, 32.45)
x <- geojson_list(vec)
centroid(x)

# list
mylist <- list(
  list(latitude = 30, longitude = 120, marker = "red"),
  list(latitude = 30, longitude = 130, marker = "blue")
)
x <- geojson_list(mylist)
centroid(x)

# data.frame
x <- geojson_list(states[1:20, ])
centroid(x)
}
