% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbox.R
\name{bbox}
\alias{bbox}
\alias{bbox_add}
\alias{bbox_get}
\title{Add or get bounding box}
\usage{
bbox_add(x, bbox = NULL)

bbox_get(x)
}
\arguments{
\item{x}{An object of class \code{geojson}}

\item{bbox}{(numeric) a vector or list of length 4 for a 2D bounding box
or length 6 for a 3D bounding box. If \code{NULL}, the bounding box is
calculated for you}
}
\value{
\itemize{
\item bbox_add: an object of class jqson/character from \pkg{jqr}
\item bbox_get: a bounding box, of the form
\code{[west, south, east, north]} for 2D or of the form
\code{[west, south, min-altitude, east, north, max-altitude]} for 3D
}
}
\description{
Add or get bounding box
}
\details{
Note that \code{bbox_get} outputs the bbox if it exists, but
does not calculate it from the geojson. See \code{\link{geo_bbox}}
to calculate a bounding box. Bounding boxes can be 2D or 3D.
}
\examples{
# make a polygon
x <- '{ "type": "Polygon",
"coordinates": [
  [ [100.0, 0.0], [101.0, 0.0], [101.0, 1.0], [100.0, 1.0], [100.0, 0.0] ]
  ]
}'
(y <- polygon(x))

# add bbox - without an input, we figure out the 2D bbox for you
y \%>\% feature() \%>\% bbox_add()
## 2D bbox
y \%>\% feature() \%>\% bbox_add(c(100.0, -10.0, 105.0, 10.0))
## 3D bbox
y \%>\% feature() \%>\% bbox_add(c(100.0, -10.0, 3, 105.0, 10.0, 17))

# get bounding box
z <- y \%>\% feature() \%>\% bbox_add()
bbox_get(z)

## returns NULL if no bounding box
bbox_get(x)
}
\references{
\url{https://datatracker.ietf.org/doc/html/rfc7946#section-5}
}
