% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictSpatial.R
\name{predictSpatial}
\alias{predictSpatial}
\title{predictSpatial}
\usage{
predictSpatial(
  imgIn,
  model,
  predOut,
  mode = "multiclass",
  predType = "class",
  biThresh = 0.5,
  doPad = FALSE,
  predPad = 0,
  useCUDA = FALSE,
  nCls,
  chpSize,
  stride_x,
  stride_y,
  crop,
  nChn = 3,
  normalize = FALSE,
  bMns,
  bSDs,
  rescaleFactor = 1,
  usedDS = FALSE
)
}
\arguments{
\item{imgIn}{Input image to classify. Can be a file path (full or relative to
current working directory) or a SpatRaster object. Should have the same number
of bands as the data used to train the model. Bands must also be in the same
order.}

\item{model}{instantiated model object as nn_module subclass as opposed to luz fitted object.
Make sure to place model in evaluation mode.}

\item{predOut}{Name of output prediction with full path or path relative to
the working directory. Must also include the file extension (e.g., ".tif).}

\item{mode}{Either "multiclass" or "binary". Default is "multiclass". If model
returns a single logit for the positive case, should be "binary". If two or more
class logits are returned, this should be "multiclass". This package treats all cases as multiclass.}

\item{predType}{"class", "logit", or "prob". Default is "class". Whether to generate a "hard"
classification ("class"), logit(s) ("logit"), or rescaled logit(s) ("prob") with a
sigmoid or softmax activation applied for the positive class or each predicted class.
If "class", a single-band raster of class indices is returned. If "logit" or "prob",
the positive class probability is returned as a single-band raster grid for a binary
classification. If "logit" or "prob" for a multiclass problem, a multiband raster grid
is returned with a channel for each class.}

\item{biThresh}{When mode = "binary" and predType = "class", threshold to use to indicate
the presence class. This threshold is applied to the rescaled logits after a sigmoid
activation is applied. Default is 0.5. If the rescaled logit is greater than or equal
to this threshold, pixel will be mapped to the positive case. Otherwise, it will be
mapped to the negative or background class. This parameter is ignored for multiclass classification.}

\item{doPad}{TRUE or FALSE. Whehter or not to add padding to chips. This is only necessary when using defineTerrainSeg().
Default is FALSE.}

\item{predPad}{Only needed when using defineTerrainSeg() and doPad = TRUE. Should be the same
as tCrop parameter in defineTerrainSeg(). Default is 0.}

\item{useCUDA}{TRUE or FALSE. Whether or not to perform the inference on a GPU.
If TRUE, the GPU is used. If FALSE, the CPU is used. Must have access to a CUDA-
enabled graphics card. Default is FALSE. Note that using a GPU significantly
speeds up inference.}

\item{nCls}{Number of classes being differentiated. Should be 1 for a binary
classification problem where only the positive case logit is predicted or
the number of classes being differentiated for a multiclass classification problem.}

\item{chpSize}{Size of image chips that will be fed through the prediction process.
We recommend using the size of the image chips used to train the model. However,
this is not strictly necessary.}

\item{stride_x}{Stride in the x direction. We recommend using a 50\% overlap.}

\item{stride_y}{Stride in the y direction. We recommend using a 50\% overlap.}

\item{crop}{Number of rows and columns to crop from each side of the image chip
to reduce edge effects. We recommend at least 20.}

\item{nChn}{Number of input channels. Default is 3.}

\item{normalize}{TRUE or FALSE. Whether to apply normalization. If FALSE,
bMns and bSDs is ignored. Default is FALSE. If TRUE, you must provide bMns
and bSDs. This should match the setting used in defineSegDataSet().}

\item{bMns}{Vector of band means. Length should be the same as the number of bands.
Normalization is applied before any rescaling within the function. This should
match the setting used in defineSegDataSet() when model was trained.}

\item{bSDs}{Vector of band standard deviations. Length should be the same
as the number of bands. Normalization is applied before any rescaling within
the function. This should match the setting used in defineSegDataSet().}

\item{rescaleFactor}{A rescaling factor to rescale the bands to 0 to 1. For
example, this could be set to 255 to rescale 8-bit data. Default is 1 or no
rescaling. This should match the setting used in defineSegDataSet().}

\item{usedDS}{TRUE or FALSE. If model is configured to use deep supervision,
this must be set to TRUE. Default is FALSE, or it is assumed that deep supervision
is not used.}
}
\value{
A spatRast object and a raster grid saved to disk of predicted class
indices (predType = "class"), logits (predType = "logit"), or rescaled logits
(predType = "prob").
}
\description{
Apply a trained semantic segmentation model to predict back to geospatial raster data
}
\details{
This function generates a pixel-by-pixel prediction using input data and a
trained semantic segmentation model. Can return either hard classifications, logits, or
rescaled logits with a sigmoid or softmax activation applied. Note that this package treats
all problems as multiclass problems and does not differentiate between binary and multiclass
classification. As a result, in our workflow the multiclass mode should be used. Result is written
to disk and provided as a spatRaster object. If you are experiencing memory issues, you may need to
break larger raster extents into smaller tiles for processing.
}
\examples{
\dontrun{
#Predict classification
predCls <- predictSpatial(imgIn="INPUT IMAGE NAME AND PATH",
                          model=model,
                          predOut="OUTPUT RASTER NAME AND PATH",
                          mode="multiclass",
                          predType="class",
                          useCUDA=TRUE,
                          nCls=2,
                          chpSize=256,
                          stride_x=128,
                          stride_y=128,
                          crop=50,
                          nChn=3,
                          normalize=FALSE,
                          rescaleFactor=255,
                          usedDS=FALSE)
}
}
