\name{estimate.compound}
\alias{estimate.compound}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Fitting a compound distribution.
}
\description{
estimate.compound computes the maximum likelihood estimates for a compound distribution. 
See arguments for supported distributions.}
\usage{
estimate.compound(x, dist = "exp", comp1 = as.null(), comp2 = as.null(), est.var = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
the vector of values to be fitted. 
}
  \item{dist}{
baseline distribution. Avaliable options: exp (exponential), gamma, lnorm (log-normal),
	paretoII, bisa (Birnbaum-Saunders), lomax, beta, kumar (Kumaraswamy), norm (normal), logis (logistic),
	cauchy, gumbel. See details for parameterizations of these distributions.
}
  \item{comp1, comp2}{
compounding distributions. Avaliable options: EXP (Exponentiated), EXP2 (Exponentiated of the second kind),
	MO (Marshall-Olkin), MO2 (Marshall-Olkin of the second kind), SB (Shaw and Buckley).
}
  \item{est.var}{
Logical. If TRUE the standard errors are estimated.
}
}
\details{
The parameterization for the different distributions is given in .
}
\value{
A list containing the following components:
\item{coefficients}{A matrix with the estimates and standard errors.}
\item{logLik}{The log-likelihood function evaluated in the estimated parameters}
\item{AIC}{Akaike's Information Criterion}
\item{BIC}{Bayesian's Information Criterion}
}
%\references{
%% ~put references to the literature/web site here ~
%}
\author{
Yolanda M. Gomez, Diego I. Gallardo, Hector W. Gomez and Barry Arnold
}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%}
\examples{
set.seed(2100)
y=rcompound(100, 1.2, 1.4, 1, 0.8, dist="exp", comp1="EXP", comp2="MO")
estimate.compound(y, dist="exp", comp1="EXP", comp2="MO")
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory (show via RShowDoc("KEYWORDS")):
% \keyword{ ~kwd1 }
% \keyword{ ~kwd2 }
% Use only one keyword per line.
% For non-standard keywords, use \concept instead of \keyword:
% \concept{ ~cpt1 }
% \concept{ ~cpt2 }
% Use only one concept per line.
