% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genpwr_wrapper.R
\name{genpwr.calc}
\alias{genpwr.calc}
\title{Function to Calculate Power for Linear Models with logistic environment interaction}
\usage{
genpwr.calc(
  calc,
  model,
  ge.interaction = NULL,
  N = NULL,
  Power = NULL,
  MAF = NULL,
  Alpha = 0.05,
  P_e = NULL,
  sd_e = NULL,
  sd_y = NULL,
  Case.Rate = NULL,
  k = NULL,
  OR = NULL,
  OR_G = NULL,
  OR_E = NULL,
  OR_GE = NULL,
  risk_allele = TRUE,
  ES = NULL,
  ES_G = NULL,
  ES_E = NULL,
  ES_GE = NULL,
  R2 = NULL,
  R2_G = NULL,
  R2_E = NULL,
  R2_GE = NULL,
  True.Model = "All",
  Test.Model = "All"
)
}
\arguments{
\item{calc}{What kind of calculation to perform? sample size ("ss"), power ("power"), or effect size ("es")}

\item{model}{Distribution of the outcome variable? ("logistic" or "linear")}

\item{ge.interaction}{If no environment interaction, should be NULL, otherwise should be "logistic" or "linear"}

\item{N}{Vector of the desired sample size(s)}

\item{Power}{Vector of the desired power(s)}

\item{MAF}{Vector of minor allele frequencies}

\item{Alpha}{the desired type 1 error rate(s)}

\item{P_e}{Vector of proportions of the population with exposure to the environmental effect}

\item{sd_e}{Standard deviation of the environmental variable}

\item{sd_y}{Standard deviation of the outcome in the population (ignoring genotype). Either sd_y_x or sd_y must be specified.}

\item{Case.Rate}{Case Rate of the outcome in the population (ignoring genotype). Either Case.Rate_x or Case.Rate must be specified.}

\item{k}{Vector of the number of controls per case. Either k or Case.Rate must be specified.}

\item{OR}{Vector of genetic odds ratios to detect in absence of environmental odds ratios}

\item{OR_G}{Vector of genetic odds ratios to detect}

\item{OR_E}{Vector of environmental odds ratios to detect}

\item{OR_GE}{Vector of genetic/environmental interaction odds ratios to detect}

\item{risk_allele}{Logical: If OR > 1, the allele is classified as a "risk allele"}

\item{ES}{Vector of effect sizes (difference in means) to detect. Either ES or R2 must be specified.}

\item{ES_G}{Vector of genetic effect sizes (difference in means) to detect. Either ES_G, ES_E, and ES_EG or R2_G, R2_E, and R2_EG must be specified.}

\item{ES_E}{Vector of environmental effect sizes (difference in means) to detect. Either ES_G, ES_E, and ES_EG or R2_G, R2_E, and R2_EG must be specified.}

\item{ES_GE}{Vector of genetic/environment interaction effect sizes (difference in means) to detect. Either ES_G, ES_E, and ES_EG or R2_G, R2_E, and R2_EG must be specified.}

\item{R2}{Vector of R-squared values to detect. Either ES or R2 must be specified.}

\item{R2_G}{Vector of genetic R-squared values to detect. Either ES_G, ES_E, and ES_EG or R2_G, R2_E, and R2_EG must be specified.}

\item{R2_E}{Vector of environmental R-squared values to detect. Either ES_G, ES_E, and ES_EG or R2_G, R2_E, and R2_EG must be specified.}

\item{R2_GE}{Vector of genetic/environment interaction R-squared values Either ES_G, ES_E, and ES_EG or R2_G, R2_E, and R2_EG must be specified.}

\item{True.Model}{A vector specifying the true underlying genetic model(s): 'Dominant', 'Additive', 'Recessive' or 'All'}

\item{Test.Model}{A vector specifying the assumed genetic model(s) used in testing: 'Dominant', 'Additive', 'Recessive' or 'All'}
}
\value{
A data frame including the power for all combinations of the specified parameters (Case.Rate, ES, Power, etc)
}
\description{
Calculates the power to detect an difference in means/effect size/regression coefficient, at a given sample size, N, with type 1 error rate, Alpha
}
\examples{
pw <- genpwr.calc(calc = "power", model = "logistic", ge.interaction = "continuous",
	N=100, OR_G=2, OR_E=1.4, OR_GE=c(1.5, 2), 
	sd_e = 1.1, MAF=0.1, Case.Rate = 0.3, Alpha=0.05,
	True.Model="All", Test.Model=c("Dominant", "Recessive"))


}
