% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/albums.R
\name{get_album}
\alias{get_album}
\title{Retrieve metadata for an album}
\usage{
get_album(album_id, access_token = genius_token())
}
\arguments{
\item{album_id}{ID of the album (\code{album_id} within an object returned by
\code{\link{get_song}})}

\item{access_token}{Genius' client access token, defaults to \code{genius_token}}
}
\value{
a \code{genius_album} object that contains the extracted content from the request,
the original JSON response object and the request path.
}
\description{
The Genius API lets you request data for a specific album, given an album ID.
\code{get_album()} returns this data in full.
}
\examples{
\dontrun{
get_album(album_id = 337082)
}
}
\seealso{
See \code{\link{get_album_df}} to return a tidy data frame.

Other album: 
\code{\link{get_album_df}()},
\code{\link{get_album_tracklist_id}()},
\code{\link{get_album_tracklist_search}()}
}
\concept{album}
