% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population.R
\name{gena.population}
\alias{gena.population}
\title{Population}
\usage{
gena.population(pop.n, lower, upper, pop.initial = NULL, method = "uniform")
}
\arguments{
\item{pop.n}{positive integer representing the number of chromosomes 
in population.}

\item{lower}{numeric vector which i-th element determines the minimum
possible value for i-th gene.}

\item{upper}{numeric vector which i-th element determines the maximum
possible value for i-th gene.}

\item{pop.initial}{numeric matrix which rows are initial chromosomes
suggested by user.}

\item{method}{string representing the initialization method to be used.
For a list of possible values see Details.}
}
\value{
This function returns a matrix which rows are chromosomes.
}
\description{
Initialize the population of chromosomes.
}
\details{
If \code{"method = uniform"} then i-th gene of each chromosome is randomly 
(uniformly) chosen between \code{lower[i]} and \code{upper[i]} bounds. If
\code{"method = normal"} then i-th gene is generated from a truncated
normal distribution with mean \code{(upper[i] + lower[i]) / 2} and
standard deviation \code{(upper[i] - lower[i]) / 6} where \code{lower[i]}
and \code{upper[i]} are lower and upper truncation bounds correspondingly.
If \code{"method = hypersphere"} then population is simulated uniformly
from the hypersphere with center \code{upper - lower} and radius
\code{sqrt(sum((upper - lower) ^ 2))} via \code{\link[gena]{rhypersphere}}
function setting \code{type = "inside"}.
}
\examples{
set.seed(123)
gena.population(pop.n = 10,
                lower = c(-1, -2, -3),
                upper = c(1, 0, -1),
                pop.initial = rbind(c(0, -1, -2),
                                    c(0.1, -1.2, -2.3)),
                method = "normal")
}
\references{
B. Kazimipour, X. Li, A. Qin (2014). 
A review of population initialization techniques for evolutionary algorithms.
\emph{2014 IEEE Congress on Evolutionary Computation}, 2585-2592,
<doi:10.1109/CEC.2014.6900618>.
}
