\name{tonsil}
\alias{tonsil}
\docType{data}
\title{Multi-Center Clinical Trial of Tonsil Carcinoma}
\description{
A tonsil cancer clinical trial study conducted by the Radiation Therapy Oncology Group in the United States. The survival time is defined as the time (in days) from diagnosis to death. In this study, patients in one institution were randomly assigned to one of two treatment groups: radiation therapy alone or radiation therapy together with a chemotherapeutic agent. A part of the data from the study is available in Kalbfleisch and Prentice (2002).}
\usage{data(tonsil)}
\format{
A part of the data from the study is available in Kalbfleisch and Prentice (2002), which includes times (in days) from diagnosis to death of 195 patients with squamous cell carcinoma of three sites in the oropharynx between 1968 and 1972 in six participating institutions. Other variables include 
  \describe{
  \item{\code{Inst}}{institution code, from 1 to 6, represents six participating institutions}
  \item{\code{Sex}}{1 = male, 2 = female.}
  \item{\code{Trt}}{treatment: 1 = standard, 2 = test.}
  \item{\code{Grade}}{1 = well differentiated, 2 = moderately differentiated, 3 = poorly differentiated.}
  \item{\code{Age}}{in years at time of diagnosis.}
  \item{\code{Cond}}{condition: 1 = no disability, 2 = restricted work, 3 = requires assistance with self care, 4 = bed confined.}
  \item{\code{Site}}{1 = faucial arch, 2 = tonsillar fossa, 3 = posterior pillar, 4 = pharyngeal tongue, 5 = posterior wall.}
  \item{\code{T}}{T staging: 1 = primary tumor measuring 2 cm or less in largest diameter; 2 = primary tumor measuring 2 to 4 cm in largest diameter, minimal infiltration in depth; 3 = primary tumor measuring more than 4 cm; 4 = massive invasive tumor.}
  \item{\code{N}}{N staging: 0 = no clinical evidence of node metastases; 1 = single positive node 3 cm or less in diameter, not fixed; 2 = single positive node more than 3 cm in diameter, not fixed; 3 = multiple positive nodes or fixed positive nodes.} 
  \item{\code{EntryDate}}{Date of entry: Day of year and year.}
  \item{\code{Status}}{0 = censored, 1 = dead.}
  \item{\code{Time}}{in days from day of diagnosis.}
  }
}
\references{
Kalbfleisch, J. D. and Prentice, R. L. (2002) \emph{The Statistical Analysis of Failure Time Data}. John Wiley &  Sons, New York, 2nd edition.
}
\keyword{datasets}
