% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R
\name{plot_geom}
\alias{plot_geom}
\title{Plot WKT or WKB geometries}
\usage{
plot_geom(x, xlab = "x", ylab = "y", main = "", ...)
}
\arguments{
\item{x}{Either a character vector containing one or more WKT strings, a raw
vector of WKB, or a list of WKB raw vectors.}

\item{xlab}{Title for the x axis.}

\item{ylab}{Title for the y axis.}

\item{main}{The main title (on top).}

\item{...}{Optional arguments passed to \code{wk::wk_plot()}.}
}
\value{
The input, invisibly.
}
\description{
\code{plot_geom()} plots one or more geometries given as either WKT or WKB raw
vectors, using \code{wk::wk_plot()}.
}
\examples{
# a Delaunay triangulation of 10 random points
set.seed(4)
x <- sample.int(100, 10)
y <- sample.int(100, 10)

g <- g_create("MULTIPOINT", cbind(x, y))
g_wk2wk(g)

plot_geom(g)

g2 <- g_delaunay_triangulation(g)
g_wk2wk(g2)

plot_geom(g2, add = TRUE)
}
