% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.gcdnet.R
\name{coef.gcdnet}
\alias{coef.gcdnet}
\alias{coef.hsvmpath}
\alias{coef.sqsvmpath}
\alias{coef.logitpath}
\alias{coef.lspath}
\alias{coef.erpath}
\title{Get coefficients or make coefficient predictions from a "gcdnet" object.}
\usage{
\method{coef}{gcdnet}(object, s = NULL, type = c("coefficients", "nonzero"), ...)
}
\arguments{
\item{object}{fitted \code{\link{gcdnet}} model object.}

\item{s}{value(s) of the penalty parameter \code{lambda} at which
predictions are required. Default is the entire sequence used to create
the model.}

\item{type}{type \code{"coefficients"} computes the coefficients at the
requested values for \code{s}. Type \code{"nonzero"} returns a list of the
indices of the nonzero coefficients for each value of \code{s}. Default is
\code{"coefficients"}.}

\item{\dots}{not used. Other arguments to predict.}
}
\value{
The object returned depends on type.
}
\description{
Computes the coefficients or returns a list of the indices of the nonzero
coefficients at the requested values for \code{lambda} from a fitted
\code{\link{gcdnet}} object.
}
\details{
\code{s} is the new vector at which predictions are requested. If \code{s}
is not in the lambda sequence used for fitting the model, the \code{coef}
function will use linear interpolation to make predictions. The new values
are interpolated using a fraction of coefficients from both left and right
\code{lambda} indices.
}
\examples{

data(FHT)
fit1 <- gcdnet(x = FHT$x,y = FHT$y)
coef(fit1, type = "coef", s = c(0.1,0.005))
coef(fit1, type = "nonzero")

}
\references{
Yang, Y. and Zou, H. (2012).
  "An Efficient Algorithm for Computing The HHSVM and Its Generalizations."
  \emph{Journal of Computational and Graphical Statistics}, 22, 396-415.\cr
  BugReport: \url{https://github.com/emeryyi/gcdnet}\cr

  Gu, Y., and Zou, H. (2016).
  "High-dimensional generalizations of asymmetric least squares regression and their applications."
  \emph{The Annals of Statistics}, 44(6), 2661–2694.\cr

  Friedman, J., Hastie, T., and Tibshirani, R. (2010).
  "Regularization paths for generalized linear models via coordinate descent."
  \emph{Journal of Statistical Software, 33, 1.}\cr
  \url{https://www.jstatsoft.org/v33/i01/}
}
\seealso{
\code{\link{predict.gcdnet}} method
}
\author{
Yi Yang, Yuwen Gu and Hui Zou\cr

  Maintainer: Yi Yang <yi.yang6@mcgill.ca>
}
\keyword{models}
\keyword{regression}
