% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_diff.R
\name{pairwise_diff}
\alias{pairwise_diff}
\title{Pairwise difference calculator}
\usage{
pairwise_diff(category_means_data, category_name)
}
\arguments{
\item{category_means_data}{Data frame containing two columns: the category-specific mean estimate (a column named \code{estimate}) and the category name (named as specified in \code{category_name})}

\item{category_name}{The name of the column containing the category identifier.}
}
\value{
A data frame with pairwise differences of \code{estimate} over pairs of categories.
}
\description{
A function to estimate the pairwise differences of estimates made for each category.
}
\examples{
sim_data <- data.frame(example_category = c("A","B","C"),
                       estimate = c(1,2,3))
pairwise_diff(sim_data, category_name = "example_category")
}
\references{
Lundberg I (2021). "The gap-closing estimand: A causal approach to study interventions that close disparities across social categories." Sociological Methods and Research. Available at {https://osf.io/gx4y3/}.

Friedman J, Hastie T, Tibshirani R (2010). "Regularization Paths for Generalized Linear Models via Coordinate Descent." Journal of Statistical Software, 33(1), 1–22. {https://www.jstatsoft.org/htaccess.php?volume=33&type=i&issue=01}.

Wood S (2017). Generalized Additive Models: An Introduction with R, 2 edition. Chapman and Hall/CRC.

Wright MN, Ziegler A (2017). "ranger: A Fast Implementation of Random Forests for High Dimensional Data in C++ and R." Journal of Statistical Software, 77(1), 1–17. doi: 10.18637/jss.v077.i01.
}
