% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeFunRegBasis.r
\name{make.funreg.basis}
\alias{make.funreg.basis}
\title{Make basis for functional regression (for internal use by other package functions)}
\usage{
make.funreg.basis(basis.type, deg, num.knots, times)
}
\arguments{
\item{basis.type}{is a character string, either \code{TruncatedPower}
or \code{BSpline}. This tells whether the basis functions should be
calculated as B-splines (see Eilers and Marx, 1996) or 
as truncated power splines (see Ruppert, Wand, and Carroll, 2003).}

\item{deg}{is the degree of the basis functions (roughly, their amount 
of complexity) and should generally be 1, 2, or 3.}

\item{num.knots}{is the number of knots in the basis; the higher 
this is, the more flexible the estimated function will be.  
If it is too low, the estimated function may be too simple
 (i.e.,biased towards being too smooth).  If it is
too high, the function may be hard to interpret.}

\item{times}{is the vector of measurement times (more technically, 
real-valued index values for the functional covariate) at which
the basis functions should be evaluated.}
}
\value{
Returns a list with two components.  The first,
\code{interior.knot.locations}, tells the selected locations on the time
axis for each interior knot. The second, \code{basis.for.betafn},
is a matrix with one row for each time value in the input vector
\code{times} and one column for each basis function. It represents
the values of the basis functions themselves.
}
\description{
This is a function for internal use (i.e., a user will not need 
to call it directly for usual data analysis tasks).  Recall that
functional coefficients are estimated as a linear combination of 
basis functions, thus changing a nonparametric into a parametric
estimation problem.  This function constructs the matrix of basis 
function values for doing a functional regression.
}
\references{
Eilers, P. H. C., and Marx, B. D. (1996). 
Flexible smoothing with B-splines and penalties (with
comments and rejoinder). Statistical Science, 11, 89-121.

 Ruppert, D., Wand, M. P., and Carroll,
 R. J. (2003) Semiparametric regression. Cambridge: Cambridge.
}
