% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{plot_simu}
\alias{plot_simu}
\title{Graphical representation of simulated data}
\usage{
plot_simu(simu)
}
\arguments{
\item{simu}{list, output of \code{\link[=simul_data]{simul_data()}}}
}
\value{
the ggplot2 graph of simulated tajectories.
}
\description{
Graphical representation of simulated data
}
\examples{
# constant delta
simu_data <- simul_data(
    n_point = 100, n_obs1 = 50, n_obs2 = 75, c_val = 5, 
    delta_shape = "constant", distrib = "normal"
)
plot_simu(simu_data)
# linear delta
simu_data <- simul_data(
    n_point = 100, n_obs1 = 50, n_obs2 = 75, c_val = 5, 
    delta_shape = "linear", distrib = "normal"
)
plot_simu(simu_data)
# quadratic delta
simu_data <- simul_data(
    n_point = 100, n_obs1 = 50, n_obs2 = 75, c_val = 5, 
    delta_shape = "quadratic", distrib = "normal"
)
plot_simu(simu_data)
}
\seealso{
\code{\link[=simul_data]{simul_data()}}
}
\author{
Zaineb Smida, Ghislain DURIF, Lionel Cucala
}
