% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsi_module.R
\name{fsi_add_cs}
\alias{fsi_add_cs}
\title{Add the consequent to an FSI model}
\usage{
fsi_add_cs(fsi, lvar, lvals, mfs, bounds)
}
\arguments{
\item{fsi}{The FSI model instantiated with the \code{fsi_create()} function.}

\item{lvar}{A character value that represents a linguistic variable of the consequent.}

\item{lvals}{A character vector that contains linguistic values of the linguistic variable of the consequent.}

\item{mfs}{A vector of membership functions (see examples below).}

\item{bounds}{A numeric vector that represents the lower and upper bounds of the consequent domain.}
}
\value{
An FSI model populated with a consequent.
}
\description{
\code{fsi_add_cs()} adds the consequent to a fuzzy spatial inference (FSI) model. It consists of a set of membership functions labeled with linguistic values.
}
\details{
The \code{fsi_add_cs()} function adds the consequent to an FSI model.
Each linguistic value defined in \code{lvals} has a corresponding membership function defined in \code{mfs}.
Thus, these two parameters must have the same length.
For instance, the first value of \code{lvals} defines the linguistic value of the first membership function in \code{mfs}.
In \code{bounds}, the lower and upper values correspond to the first and second parameter, respectively.
}
\examples{
# Defining two different types of membership functions
trap_mf <- function(a, b, c, d) {
  function(x) {
    pmax(pmin((x - a)/(b - a), 1, (d - x)/(d - c), na.rm = TRUE), 0)
  }
}

trim_mf <- function(a, b, c) {
  function(x) {
    pmax(pmin((x - a)/(b - a), (c - x)/(c - b), na.rm = TRUE), 0)
  }
}

# Creating the FSI model
fsi <- fsi_create("To visit or not to visit, that is the question", 
                   default_conseq = trim_mf(10, 30, 60))

# Creating the vector with the linguistic values of the linguistic variable "visiting experience"
lvals_visiting_exp <- c("awful", "average", "great")

# Defining the membership function for each linguistic value
awful_mf <- trim_mf(0, 0, 20)
average_mf <- trim_mf(10, 30, 60)
great_mf <- trap_mf(40, 80, 100, 100)

# Adding the consequent to the FSI model
fsi <- fsi_add_cs(fsi, "visiting experience", lvals_visiting_exp,
                  c(awful_mf, average_mf, great_mf), c(0, 100))
}
\references{
\href{https://dl.acm.org/doi/10.1145/3474717.3484255}{Carniel, A. C.; Galdino, F.; Philippsen, J. S.; Schneider, M. Handling Fuzzy Spatial Data in R Using the fsr Package. In Proceedings of the 29th International Conference on Advances in Geographic Information Systems (AM SIGSPATIAL 2021), pp. 526-535, 2021.}

Underlying concepts and formal definitions of FSI models are introduced in:
\itemize{
\item \href{https://ieeexplore.ieee.org/document/8015707}{Carniel, A. C.; Schneider, M. Fuzzy inference on fuzzy spatial objects (FIFUS) for spatial decision support systems. In Proceedings of the 2017 IEEE International Conference on Fuzzy Systems (FUZZ-IEEE 2017), pp. 1-6, 2017.}
}
}
