% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powers_of_ten.R
\name{powers_of_ten}
\alias{powers_of_ten}
\alias{convert_to_power_of_ten}
\alias{convert_from_power_of_ten}
\alias{df_to_powers_of_ten}
\alias{df_from_powers_of_ten}
\title{Conversions from or to powers of ten.}
\usage{
convert_to_power_of_ten(x, exponent = NULL)

convert_from_power_of_ten(x)

df_to_powers_of_ten(x, is_individual = FALSE)

df_from_powers_of_ten(x)
}
\arguments{
\item{x}{A data frame with attributed numeric columns.}

\item{exponent}{Specify an exponent instead of deriving one from the data.}

\item{is_individual}{Use individual powers of ten for each numeric column in
\code{x}? But why would you want to?}
}
\value{
An attributed numeric vector.

A numeric vector.

A data frame with attributed numeric columns.

A  data frame.
}
\description{
I often need to table big numbers in non-scientific notation.
}
\examples{
# Using vectors

print(x <- (5 + rnorm(15)) * 10^11)
convert_to_power_of_ten(x, 6)
print(y <- convert_to_power_of_ten(x))
all.equal(x, convert_from_power_of_ten(y))

# Using data frames 
## same exponent for all numeric columns
x <- (5 + rnorm(15)) * 10^11
df <- data.frame(x, y = x * 10^3, z = letters[seq_along(x)],
                row.names = as.character(seq_along(x)))
x <- df_to_powers_of_ten(df)
str(x)
y <- df_from_powers_of_ten(x) 
identical(df, y)
## individual exponents for different columns - but what for?
### automatically
### manually
df1 <- df
df1[["x"]] <- convert_to_power_of_ten(df1[["x"]])
df1[["y"]] <- convert_to_power_of_ten(df1[["y"]])
str(df1)
print(df2 <- df_from_powers_of_ten(df1))
identical(df, df2)
}
\seealso{
Other statistics: 
\code{\link{column_sums}()},
\code{\link{count_groups}()},
\code{\link{relative_difference}()},
\code{\link{round_half_away_from_zero}()},
\code{\link{sloboda}()},
\code{\link{weighted_variance}()}

Other vector functions: 
\code{\link{char2factor}()},
\code{\link{escape_non_ascii}()},
\code{\link{file_string}()}

Other vector functions: 
\code{\link{char2factor}()},
\code{\link{escape_non_ascii}()},
\code{\link{file_string}()}

Other statistics: 
\code{\link{column_sums}()},
\code{\link{count_groups}()},
\code{\link{relative_difference}()},
\code{\link{round_half_away_from_zero}()},
\code{\link{sloboda}()},
\code{\link{weighted_variance}()}

Other statistics: 
\code{\link{column_sums}()},
\code{\link{count_groups}()},
\code{\link{relative_difference}()},
\code{\link{round_half_away_from_zero}()},
\code{\link{sloboda}()},
\code{\link{weighted_variance}()}
}
\concept{statistics}
\concept{vector functions}
