% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo.R
\name{geo_too_large}
\alias{geo_too_large}
\title{Check if an sf object exceeds size or extent thresholds}
\usage{
geo_too_large(
  x,
  area_threshold = 1e+09,
  extent_threshold = 150000,
  verbose = TRUE
)
}
\arguments{
\item{x}{An \code{sf} object to check.}

\item{area_threshold}{Numeric. Maximum allowed area in m2 (for polygon geometries). Default is 1e9.}

\item{extent_threshold}{Numeric. Maximum allowed bounding box width or height in meters. Default is 1.5e5.}

\item{verbose}{Logical. If \code{TRUE}, prints a message when the object is within limits.}
}
\value{
Invisibly returns \code{FALSE} if within limits. Throws an error if thresholds are exceeded.
}
\description{
This internal helper evaluates whether a spatial object is too large based
on area (for polygons) and bounding box dimensions.
}
\keyword{internal}
