% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bs4dash.R
\name{bs4dash_yiq}
\alias{bs4dash_yiq}
\title{bs4Dash color contrast}
\usage{
bs4dash_yiq(contrasted_threshold = NULL, text_dark = NULL, text_light = NULL)
}
\arguments{
\item{contrasted_threshold}{The yiq lightness value that
determines when the lightness of color changes from "dark"
to "light". Acceptable values are between 0 and 255.}

\item{text_dark}{Dark text color.}

\item{text_light}{Light text color.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
These variables allow to customize color used if
contrast between a color and its background is under threshold.
For example, it's used to choose text color written in \code{bs4ValueBox}
with background defined by a status.
}
\examples{

# Contrast colors
bs4dash_yiq(
  contrasted_threshold = 150,
  text_dark = "#007bff", # blue
  text_light = "#dc3545" # red
)

if (interactive()) {

  library(shiny)
  library(bs4Dash)

  ui <- bs4DashPage(
    title = "bs4Dash Contrast",
    navbar = bs4DashNavbar(),
    sidebar = bs4DashSidebar(),
    body = bs4DashBody(

      use_theme(create_theme(
        bs4dash_yiq(
          contrasted_threshold = 180,
          text_dark = "#000",
          text_light = "#dc3545"
        )
      )),

      fluidRow(
        bs4ValueBox(
          value = 120,
          subtitle = "ValueBox with primary status",
          status = "primary",
          icon = "shopping-cart",
          href = "#",
          width = 4
        ),
        bs4ValueBox(
          value = 150,
          subtitle = "ValueBox with danger status",
          status = "danger",
          icon = "shopping-cart",
          href = "#",
          width = 4
        )
      )
    )
  )

  server <- function(input, output) {

  }

  shinyApp(ui, server)

}
}
