% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cspline.R
\name{\%inside\%}
\alias{\%inside\%}
\title{Check if points lie inside a simple polygon}
\usage{
points \%inside\% polygon
}
\arguments{
\item{points}{a data.frame with components x,y specifying the points}

\item{polygon}{a data.frame with components x,y specifying the polygon}
}
\value{
a logical value matching the number of points, TRUE = "inside"
}
\description{
Check if points lie inside a simple polygon
}
\examples{
oldPar <- par(pty = "s", las = 1, xpd = NA)
pts <- expand.grid(x = seq(0, 1, len=25), y = seq(0, 1, len=25))
pol <- (1 + 1i)/2 + complex(argument = seq(-base::pi, base::pi, len=100))/3
show_red <- as_points(pts) \%inside\% as_polygon(pol)
plot(pts, col = ifelse(show_red, "red", "royal blue"), ann = FALSE, bty = "n",
     pch = ".", cex = ifelse(show_red, 4, 2.5), asp = 1)
polygon(pol, lwd = 0.5)
par(oldPar)
}
