% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_fs_annot.R
\name{write.fs.annot.gii}
\alias{write.fs.annot.gii}
\title{Write annotation to GIFTI file.}
\usage{
write.fs.annot.gii(filepath, annot)
}
\arguments{
\item{filepath}{string, path to the output file.}

\item{annot}{fs.annot instance, an annotation.}
}
\description{
Write an annotation to a GIFTI XML file.
}
\note{
This function does not write a GIFTI file that is valid according to the specification: it stores extra color data in the Label nodes, and there is more than one Label in the LabelTable node.
}
\examples{
\dontrun{
   # Load annotation
   annot_file = system.file("extdata", "lh.aparc.annot.gz",
                               package = "freesurferformats",
                               mustWork = TRUE);
   annot = read.fs.annot(annot_file);

   # New method: write the annotation instance:
   write.fs.annot.gii(tempfile(fileext=".annot"), annot);

}

}
\seealso{
Other atlas functions: 
\code{\link{colortable.from.annot}()},
\code{\link{read.fs.annot}()},
\code{\link{read.fs.colortable}()},
\code{\link{write.fs.annot}()},
\code{\link{write.fs.colortable}()}

Other gifti writers: 
\code{\link{write.fs.label.gii}()},
\code{\link{write.fs.morph.gii}()},
\code{\link{write.fs.surface.gii}()}
}
\concept{atlas functions}
\concept{gifti writers}
