% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen.R
\name{sample_data}
\alias{sample_data}
\title{sample_data}
\usage{
sample_data(
  nherds = 500,
  mean_herd_size = 50,
  n_herd_urg = 2,
  herd_dist = c(0.8, 0.2),
  herd_samp_frac = 0.5,
  herd_samp_dist = c(0.5, 0.5),
  n_animal_urg = 2,
  animal_dist = c(0.5, 0.5),
  animal_samp_frac = 0.15,
  animal_samp_dist = c(0.5, 0.5),
  seed = NULL
)
}
\arguments{
\item{nherds}{The total number of herds}

\item{mean_herd_size}{The mean herd size in the population}

\item{n_herd_urg}{The number of different herd risk groups}

\item{herd_dist}{The fraction of herds in each risk group}

\item{herd_samp_frac}{The total sampling fraction at the herd
level}

\item{herd_samp_dist}{The fraction of samples to be collected from
each herd risk group}

\item{n_animal_urg}{The number of animal level risk groups}

\item{animal_dist}{The fraction of animals within herds that are
part of each risk group}

\item{animal_samp_frac}{The total sampling fraction of animals
within herds}

\item{animal_samp_dist}{The fraction of samples that are collected
from each animal risk group}

\item{seed}{The seed for the random number generator. Default is a
random seed}
}
\value{
A data.frame
}
\description{
A function to generate some synthetic data based on a few
parameters.
}
\examples{
## Generate the default example data. This will generate a
## data.frame with a herd identifier (ppn), a herd level unit risk
## group identifier (herd_urg), a animal level unit risk group
## identifier (animal_urg), the total number of animals in the unit
## risk group (N_animal_urg) and the number of animals tested in the
## unit risk group (n_animals_urg).

df <- sample_data()
}
