% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHelp.R
\docType{data}
\name{Paq810}
\alias{Paq810}
\title{Filtered Paquid Sample Data Set for Illness-Death Modeling}
\format{
A data frame with approximately 810 rows (original 1000 minus exclusions)
  and the following 8 columns:
  \describe{
    \item{dementia}{Dementia status indicator: 0 = non-demented, 1 = demented.}
    \item{death}{Death status indicator: 0 = alive, 1 = dead.}
    \item{e}{Age at entry into the study (left-truncation time).}
    \item{l}{For demented subjects: age at the visit *before* the diagnostic visit. For non-demented subjects: age at the last visit.}
    \item{r}{Age at dementia diagnosis or censoring for dementia (event/censoring time for 0->1 transition). Guaranteed to be > `e`.}
    \item{t}{Overall exit age. For dead subjects: age at death. For alive subjects: age at the latest news (censoring time for death).}
    \item{certif}{Primary school certificate indicator: 0 = without certificate, 1 = with certificate.}
    \item{gender}{Gender indicator: 0 = female, 1 = male.}
}
}
\source{
Derived from the \code{Paq1000} dataset, which originates from the
  Paquid study and is included in the \code{SmoothHazard} package.
}
\usage{
data(Paq810)
}
\description{
A dataset derived from \code{Paq1000} (originally a sample from the Paquid
study available via the \code{SmoothHazard} package). This version excludes
subjects where the age of dementia diagnosis or censoring ('r') was exactly 
equal to the age at study entry ('e'), ensuring valid observation intervals
when using left truncation.
}
\details{
This dataset was created by filtering the \code{Paq1000} data:
\code{Paq810 <- Paq1000[Paq1000$r > Paq1000$e, ]}.
This step is necessary to prevent issues with \code{survival::Surv(e, r, dementia)}
which requires the stop time ('r') to be strictly greater than the start/entry
time ('e').

The time variables `e`, `l`, `r`, and `t` are all ages in years.
This dataset is suitable for fitting illness-death models with left truncation
using functions like \code{IllnessDeath}.
}
\seealso{
\code{Paq1000}, The \code{SmoothHazard} package.
}
\keyword{datasets}
