% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fracdist.R
\docType{package}
\name{.fracdist}
\alias{.fracdist}
\title{Numerical CDFs for
Fractional Unit Root and Cointegration Tests}
\value{
Returns \code{NULL}. Object included for description only.
}
\description{
A package for calculating numerical distribution functions of fractional
unit root and cointegration test statistics. The included functions calculate
critical values and P-values used in unit root tests, cointegration tests,
and rank tests in the Fractionally Cointegrated Vector
Autoregression (FCVAR) model (see Johansen and Nielsen, 2012).
}
\details{
Simple tabulation is not a feasible approach for obtaining
critical values and P-values because these distributions depend
on a real-valued parameter \code{b} that must be estimated.
Instead, response surface regressions are used to obtain the numerical
distribution functions and combined by model averaging
across values taken from a series of tables.
As a function of the dimension of the problem, \code{q},
and a value of the fractional integration order \code{b},
this approach provides either a set of critical values or the asymptotic P-value
for any value of the likelihood ratio statistic.
The P-values and critical values are calculated by interpolating from the
quantiles on a grid of probabilities and values of the fractional integration order,
with separate tables for a range of values of cointegrating rank.

The functions in this package are based on the functions and subroutines in the
Fortran program \code{fracdist.f} to accompany an article by MacKinnon and Nielsen (2014).
This program is available from the archive of the \emph{Journal of Applied Econometrics}
at \url{http://qed.econ.queensu.ca/jae/datasets/mackinnon004/}.
Alternatively, a C++ implementation of this program is also available; see
\url{https://github.com/jagerman/fracdist/blob/master/README.md} for details.
}
\references{
James G. MacKinnon and Morten \enc{Ø}{O}rregaard Nielsen,
"Numerical Distribution Functions of Fractional Unit Root and Cointegration Tests,"
\emph{Journal of Applied Econometrics}, Vol. 29, No. 1, 2014, pp.161-171.

Johansen, S. and M. \enc{Ø}{O}. Nielsen (2012).
"Likelihood inference for a fractionally cointegrated vector autoregressive model,"
\emph{Econometrica} 80, pp.2667-2732.
}
