% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval.R
\name{tidy_eval}
\alias{tidy_eval}
\title{Insert output to source code}
\usage{
tidy_eval(
  source = "clipboard",
  ...,
  file = "",
  prefix = "## ",
  envir = parent.frame()
)
}
\arguments{
\item{source}{The input file name (by default the clipboard; see
\code{\link{tidy_source}()}).}

\item{...}{Other arguments passed to \code{\link{tidy_source}()}.}

\item{file}{The file name to write to via \code{\link{cat}()}.}

\item{prefix}{The prefix to mask the output.}

\item{envir}{The environment in which to evaluate the code. By default the
parent frame; set \code{envir = NULL} or \code{envir = new.env()} to avoid
the possibility of contaminating the parent frame.}
}
\value{
Evaluated R code with corresponding output (printed on screen or
  written to a file).
}
\description{
Evaluate R code by chunks, then insert the output to each chunk. As the
output is masked in comments, the source code will not break.
}
\examples{
library(formatR)
## evaluate simple code as a character vector
tidy_eval(text = c("a<-1+1;a", "matrix(rnorm(10),5)"))

## evaluate a file
tidy_eval(system.file("format", "messy.R", package = "formatR"))
}
\references{
\url{https://yihui.org/formatR/}
}
