% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint_methods.R
\name{confint}
\alias{confint}
\alias{confint.onephase}
\alias{confint.twophase}
\alias{confint.threephase}
\title{Calculates Confidence Intervals for Global and Small-Area Estimations}
\usage{
\method{confint}{onephase}(object, parm, level = 0.95, adjust.method = "none", ...)

\method{confint}{twophase}(object, parm, level = 0.95, adjust.method = "none", ...)

\method{confint}{threephase}(object, parm, level = 0.95, adjust.method = "none", ...)
}
\arguments{
\item{object}{object of class \code{onephase}, \code{twophase} or \code{threephase},
containing estimation results of the respective estimation method.}

\item{parm}{ignored.}

\item{level}{the confidence level required.}

\item{adjust.method}{correction method to obtain simultaneous confidence intervals
for a set of estimates (thus restricted to objects of class \code{"onephase"},
\code{c("smallarea", "twophase")} and  \code{c("smallarea", "threephase")}).
Available correction methods are \code{c("none","bonferroni")}. Defaults to \code{"none"}.}

\item{...}{additional arguments, so far ignored.}
}
\value{
\code{confint} returns a list of  the following 3 components:

 \item{ci}{a \code{data.frame} containing the columns:
                   \itemize{
                   \item \code{area} the domain, i.e. small area
                   \item \code{ci_lower_ext} the lower confidence limit based on the external variance
                   \item \code{ci_upper_ext} the upper confidence limit based on the external variance
                   \item \code{ci_lower_g}   the lower confidence limit based on the g-weight variance
                   \item \code{ci_upper_g}   the upper confidence limit based on the g-weight variance
                   }}
 \item{level}{the applied confidence level}
 \item{adjust.method}{the adjustment method applied to retrieve simultaneous confidence intervals}
}
\description{
Calculates Confidence Intervals for Global and Small-Area Estimations
}
\details{
Depending on the estimation method specified, \code{confint()} computes confidence intervals as follows:

\code{\link{onephase}}:

Two-sided confidence intervals are computed based on the t-distribution with \code{n2 - 1} \emph{degrees of freedom},
where \code{n2} is the number of terrestrial data in the respective inventory domain.

\code{\link{twophase}}:

The calculation of the two-sided confidence intervals for \emph{global} twophase estimates
(objects of class \code{global}) are calculated based on the quantiles of the \emph{t}-distribution
with \code{n2 - p} \emph{degrees of freedom}, where \code{p} is the number of parameters used in
the regression model, and \code{n2} is the number of terrestrial observations (i.e. \emph{local densities})
in the inventory domain.

The calculation of the two-sided confidence intervals for \emph{smallarea} twophase estimates
(objects of class \code{smallarea}) are calculated based on the quantiles of the \emph{t}-distribution
with \code{n2G - 1} \emph{degrees of freedom}, where \code{n2G} is the number of
terrestrial observations (i.e. \emph{local densities}) in the smallarea.

\code{\link{threephase}}:

The calculation of the two-sided confidence intervals for \emph{global} threephase estimates
(objects of class \code{global}) are calculated based on the quantiles of the \emph{t}-distribution
with \code{n2 - p} \emph{degrees of freedom}, where \code{p} is the number of parameters used in
the \strong{full} regression model, and \code{n2} is the number of terrestrial observations
(i.e. \emph{local densities}) in the inventory domain (note: in notation used here n0, n1 and n2
correspond to the zero, first and second phase sample sizes respectively).

The calculation of the two-sided confidence intervals for \emph{smallarea} theephase estimates
(objects of class \code{smallarea}) are calculated based on the quantiles of the \emph{t}-distribution
with \code{n2G - 1} \emph{degrees of freedom}, where \code{n2G} is the number of
terrestrial observations (i.e. \emph{local densities}) in the smallarea.
}
\note{
In the special case of \emph{synthetic} smallarea estimations, the two-sided confidence intervals
are calculated based on the quantiles of the \emph{t}-distribution
with \code{n2 - p} \emph{degrees of freedom}, i.e. based on the global sample size.

The confidence intervals for \emph{synthetic} smallarea estimations do not account for the potential
bias of a linear model that was fit in a large forest area and applied to a small area.  Thus,
the coverage rates for confidence intervals produced by synthetic estimators may be less than
the nominal level of confidence.

In case of cluster-sampling, \code{n2G} is the number of terrestrial clusters
(a cluster constitutes the sample unit). This is automatically considered by \code{confint}.

The adjustment methods passed to \code{adjust.method} are designed to achieve
\emph{simultaneous} confidence intervals by correcting the confidence level given by \code{level}.
The use of this option is recommended if a set of estimates contained in a \code{onephase}- or
\code{smallarea}-object should be compared by their confidence intervals. It ensures that the
percentage of confidence intervals containing the true value will correspond to
the nominal confidence level.
}
\examples{
## Calculate twophase estimations by extended pseudosynthetic estimator
#  for 4 small areas ("A", "B", "C", "D") using the grisons-dataset:
sae.est <- twophase(formula = tvol ~ mean + stddev + max + q75,
                    data = grisons,
                    phase_id = list(phase.col = "phase_id_2p", terrgrid.id = 2),
                    small_area = list(sa.col = "smallarea",
                                      areas = c("A", "B","C", "D"),
                                      unbiased = TRUE))

## calculate 95\%-confidence intervals for each small area:
confint(sae.est)

## calculate simultaneous 95\%-confidence intervals using 'bonferroni'-method:
confint(sae.est, adjust.method = "bonferroni")
}
\references{
Hill, A., Massey, A. F. (2021). \emph{The R Package forestinventory: Design-Based Global and Small
Area Estimations for Multiphase Forest Inventories.} Journal of Statistical Software, 97(4), 1-40.

Mandallaz, D. (2013). \emph{Design-based properties of some small-area estimators in forest inventory
with two-phase sampling.} Canadian Journal of Forest Research, 43(5), 441-449.

Mandallaz, D., Breschan, J., & Hill, A. (2013). \emph{New regression estimators in forest inventories
with two-phase sampling and partially exhaustive information: a design-based monte carlo approach
with applications to small-area estimation.} Canadian Journal of Forest Research,
43(11), 1023-1031.

Mandallaz, D. (2013). \emph{A three-phase sampling extension of the generalized regression estimator
with partially exhaustive information.} Canadian Journal of Forest Research,
44(4), 383-388.

Benjamini, Y., and Hochberg, Y. (1995). \emph{Controlling the false discovery rate:
a practical and powerful approach to multiple testing.}
Journal of the Royal Statistical Society Series B 57, 289-300.
}
