% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast2.R
\name{forecast.StructTS}
\alias{forecast.StructTS}
\title{Forecasting using Structural Time Series models}
\usage{
\method{forecast}{StructTS}(
  object,
  h = if (object$coef["epsilon"] > 1e-10) 2 * object$xtsp[3] else 10,
  level = c(80, 95),
  fan = FALSE,
  lambda = NULL,
  biasadj = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{StructTS}. Usually the result of a
call to \code{\link[stats:StructTS]{stats::StructTS()}}.}

\item{h}{Number of periods for forecasting. Default value is twice the
largest seasonal period (for seasonal data) or ten (for non-seasonal data).}

\item{level}{Confidence levels for prediction intervals.}

\item{fan}{If \code{TRUE}, \code{level} is set to \code{seq(51, 99, by = 3)}.
This is suitable for fan plots.}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda = "auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{biasadj}{Use adjusted back-transformed mean for Box-Cox
transformations. If transformed data is used to produce forecasts and fitted
values, a regular back transformation will result in median forecasts. If
biasadj is \code{TRUE}, an adjustment will be made to produce mean forecasts
and fitted values.}

\item{...}{Other arguments are ignored.}
}
\value{
An object of class \code{forecast}.
}
\description{
Returns forecasts and other information for univariate structural time
series models.
}
\details{
This function calls \code{predict.StructTS} and constructs an object of
class \code{forecast} from the results.
}
\section{forecast class}{

An object of class \code{forecast} is a list usually containing at least
the following elements:
\describe{
\item{model}{A list containing information about the fitted model}
\item{method}{The name of the forecasting method as a character string}
\item{mean}{Point forecasts as a time series}
\item{lower}{Lower limits for prediction intervals}
\item{upper}{Upper limits for prediction intervals}
\item{level}{The confidence values associated with the prediction intervals}
\item{x}{The original time series.}
\item{residuals}{Residuals from the fitted model. For models with additive
errors, the residuals will be x minus the fitted values.}
\item{fitted}{Fitted values (one-step forecasts)}
}
The function \code{summary} can be used to obtain and print a summary of the
results, while the functions \code{plot} and \code{autoplot} produce plots of the forecasts and
prediction intervals. The generic accessors functions \code{fitted.values} and \code{residuals}
extract various useful features from the underlying model.
}

\examples{
fit <- StructTS(WWWusage, "level")
plot(forecast(fit))

}
\seealso{
\code{\link[stats:StructTS]{stats::StructTS()}}.
}
\author{
Rob J Hyndman
}
\keyword{ts}
