% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_abundances.R,
%   R/compute_concentrations.R, R/compute_frequencies.R
\name{compute_abundances}
\alias{compute_abundances}
\alias{computations}
\alias{compute_concentrations}
\alias{compute_frequencies}
\title{Compute count conversions}
\usage{
compute_abundances(data, aggregate = TRUE)

compute_concentrations(data, aggregate = TRUE)

compute_frequencies(data, aggregate = TRUE)
}
\arguments{
\item{data}{a \code{tibble} or a \code{data.frame}. One obtained by \verb{read_*_data()}
functions.}

\item{aggregate}{a \code{logical} of length 1. If \code{FALSE} counts will be derived
for each subsample. If \code{TRUE} (default) subsample counts will be
aggregated by \code{sample_id}.}
}
\value{
A \code{tibble} in long format with two additional columns: \code{taxa},
the taxon name and \verb{counts_*}, the number concentration (\code{counts_n_conc}) or
the relative abundance (\code{counts_rel_ab}) or the raw abundance
(\code{counts_raw_ab}).
}
\description{
Functions to convert species counts between different formats: raw abundance,
relative abundance, and number concentration, using counts metadata.
}
\details{
\itemize{
\item \code{compute_concentrations()} converts all counts to number concentrations
(n specimens/m³).
\item \code{compute_frequencies()} converts all counts to relative abundances
(\% specimens per sampling unit).
\item \code{compute_abundances()} converts all counts to raw abundances
(n specimens/sampling unit).
}
}
\examples{
# Import example dataset ----
file_name <- system.file(file.path("extdata", "FORCIS_net_sample.csv"),
                         package = "forcis")

net_data <- read.csv(file_name)

# Select a taxonomy ----
net_data <- select_taxonomy(net_data, taxonomy = "VT")

# Dimensions of the data.frame ----
dim(net_data)

# Compute concentration ----
net_data_conc <- compute_concentrations(net_data)

# Dimensions of the data.frame ----
dim(net_data_conc)
}
