% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foot_prob.R
\name{foot_prob}
\alias{foot_prob}
\title{Plot football matches probabilities for out-of-sample football matches.}
\usage{
foot_prob(object, data, home_team, away_team)
}
\arguments{
\item{object}{An object either of class \code{stanFoot}, \code{CmdStanFit}, \code{\link[rstan]{stanfit}}, or class
\code{\link{list}} containing the Maximum Likelihood Estimates (MLE) for the model parameters fitted
 with \code{mle_foot}.}

\item{data}{A data frame containing match data with columns:
\itemize{
  \item \code{periods}:  Time point of each observation (integer >= 1).
  \item \code{home_team}: Home team's name (character string).
  \item \code{away_team}: Away team's name (character string).
  \item \code{home_goals}: Goals scored by the home team (integer >= 0).
  \item \code{away_goals}: Goals scored by the away team (integer >= 0).
}}

\item{home_team}{The home team(s) for the predicted matches.}

\item{away_team}{The away team(s) for the predicted matches.}
}
\value{
A list with components:
 \itemize{
 \item \code{prob_table}: A data frame containing the results probabilities of the out-of-sample matches.
 \item \code{prob_plot}: A \code{ggplot} object for Bayesian models only showing the posterior predictive heatmap
  of exact score probabilities, with the true result highlighted.
}
}
\description{
The function provides a table containing the home win, draw and away win probabilities for a bunch of
out-of-sample matches as specified by \code{stan_foot} or \code{mle_foot}.
}
\details{
For Bayesian models the results probabilities are computed according to the
simulation from the posterior predictive distribution of future (out-of-sample) matches.
Specifically, matches are ordered from those in which the favorite team has the highest posterior probability
of winning to those where the underdog is more likely to win. For MLE models
fitted via the \code{mle_foot} the probabilities are computed by simulating from the MLE estimates.
}
\examples{
\dontrun{
if (instantiate::stan_cmdstan_exists()) {
  library(dplyr)

  data("italy")
  italy_2000 <- italy \%>\%
    dplyr::select(Season, home, visitor, hgoal, vgoal) \%>\%
    dplyr::filter(Season == "2000")

  colnames(italy_2000) <- c("periods", "home_team", "away_team", "home_goals", "away_goals")



  fit <- stan_foot(
    data = italy_2000,
    model = "double_pois",
    predict = 18
  ) # double pois

  foot_prob(
    fit, italy_2000, "Inter",
    "Bologna FC"
  )

  foot_prob(fit, italy_2000) # all the out-of-sample matches
}
}

}
\author{
Leonardo Egidi \email{legidi@units.it} and Roberto Macrì Demartino \email{roberto.macridemartino@deams.units.it}.
}
