% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanup_folders.R
\name{cleanup_folders}
\alias{cleanup_folders}
\title{Cleanup Folders}
\usage{
cleanup_folders(folders, conf_file = NULL, keep_conf = TRUE, recursive = FALSE)
}
\arguments{
\item{folders}{(list) A named list of standard folders for an R project.}

\item{conf_file}{(character) Configuration file to read/write. 
See: config::get(). (Default: NULL)}

\item{keep_conf}{(boolean) Keep the configuration file if TRUE. (Default: TRUE)}

\item{recursive}{(boolean) Cleanup subfolders recursively if TRUE. (Default: FALSE)}
}
\value{
(integer) A vector of results: 0 for success; 1 for failure; NULL for skipped.
}
\description{
Remove empty folders from the folders list as well as the configuration file.
}
\section{Details}{

Each empty folder in the list of folders will be removed. If recursive is
set to TRUE, then empty subfolders will be removed first. The configuration  
file will be removed if keep_conf is set to FALSE.
}

\examples{
# Create list of standard folder names and store in a configuration file
conf_file <- tempfile("folders.yml")     # Using tempfile() for testing only
folders <- get_folders(conf_file)

# Testing only: Append folder names to parent folder path --
#               This would NOT be needed or desired in normal usage
folders <- lapply(folders, function(x) file.path(tempdir(), x))

# Create a folder for each item in "folders" list
result <- create_folders(folders)

# Remove empty folders, leaving only those with files or subfolders in them
result <- cleanup_folders(folders)
}
\keyword{consistency}
