% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf.R
\name{gen_hrf}
\alias{gen_hrf}
\title{Construct an HRF Instance using Decorators}
\usage{
gen_hrf(
  hrf,
  lag = 0,
  width = 0,
  precision = 0.1,
  half_life = Inf,
  summate = TRUE,
  normalize = FALSE,
  name = NULL,
  span = NULL,
  ...
)
}
\arguments{
\item{hrf}{A function `f(t)` or an existing `HRF` object.}

\item{lag}{Optional lag in seconds. If non-zero, applies `lag_hrf`.}

\item{width}{Optional block width in seconds. If non-zero, applies `block_hrf`.}

\item{precision}{Sampling precision for block convolution (passed to `block_hrf`). Default is 0.1.}

\item{half_life}{Half-life decay parameter for exponential decay in seconds (passed to `block_hrf`). Default is Inf (no decay).}

\item{summate}{Whether to summate within blocks (passed to `block_hrf`). Default is TRUE.}

\item{normalize}{If TRUE, applies `normalise_hrf` at the end. Default is FALSE.}

\item{name}{Optional name for the *final* HRF object. If NULL (default), a name is generated based on the base HRF and applied decorators.}

\item{span}{Optional span for the *final* HRF object. If NULL (default), the span is determined by the base HRF and decorators.}

\item{...}{Extra arguments passed to the *base* HRF function if `hrf` is a function.}
}
\value{
A final `HRF` object, potentially modified by decorators.
}
\description{
`gen_hrf` takes a base HRF function or object and applies optional lag,
blocking, and normalization decorators based on arguments.
}
\examples{
# Lagged SPMG1
grf_lag <- gen_hrf(HRF_SPMG1, lag=3)
# Blocked Gaussian
grf_block <- gen_hrf(hrf_gaussian, width=5, precision=0.2)
# Lagged and Blocked, then Normalized
grf_both_norm <- gen_hrf(HRF_SPMG1, lag=2, width=4, normalize=TRUE)

}
