% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11_flow_view_shiny.R
\name{flow_view_shiny}
\alias{flow_view_shiny}
\title{Visualize a shiny app's dependency graph}
\usage{
flow_view_shiny(
  fun,
  max_depth = Inf,
  trim = NULL,
  promote = NULL,
  demote = NULL,
  hide = NULL,
  show_imports = c("functions", "packages", "none"),
  out = NULL,
  lines = TRUE,
  pattern = "(_ui)|(_server)|(Ui)|(Server)|(UI)|(SERVER)"
)
}
\arguments{
\item{fun}{The function that runs the app}

\item{max_depth}{An integer, the maximum depth to display}

\item{trim}{A vector or list of function names where the recursion will stop}

\item{promote}{A vector or list of external functions to show as internal functions}

\item{demote}{A vector or list of internal functions to show as external functions}

\item{hide}{A vector or list of internal functions to completely remove from the chart}

\item{show_imports}{Whether to show imported "functions", only "packages", or "none"}

\item{out}{a path to save the diagram to.
Special values "html", "htm", "png", "pdf", "jpg" and "jpeg" can be used to
export the object to a temp file of the relevant format and open it,
if a regular path is used the format will be guessed from the extension.}

\item{lines}{Whether to show the number of lines of code next to the function name}

\item{pattern}{A regular expression used to detect ui and server functions}
}
\value{
A flow diagram object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This function displays a shiny app's module structure, assuming it is built
on top of module functions named a certain way (adjustable through the \code{pattern} argument) and
calling each other. If you call for instance \code{flow_view_shiny()} on a function that runs the app and
uses both the main server and ui functions, you'll display the full graph of server and ui modules.
}
\details{
It is  wrapper around \code{flow_view_deps()} which demotes every object that is not
a server function, a ui function or a function calling either. What is or isn't considered as a
server or ui function depends on a regular expression provided through the \code{pattern}
argument. For a more general way of displaying all dependencies (not focused on modules),
use \code{flow_view_deps()}.
}
\examples{
if (requireNamespace("esquisse", quietly = TRUE)) {
  flow_view_shiny(esquisse::esquisser, show_imports = "none")
}
}
