% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flip-object.R
\docType{class}
\name{flip.object-class}
\alias{flip.object-class}
\alias{show,flip.object-method}
\alias{summary}
\alias{summary,flip.object-method}
\alias{dim,flip.object-method}
\alias{[,flip.object-method}
\alias{[[}
\alias{[[,flip.object-method}
\alias{length}
\alias{length,flip.object-method}
\alias{names,flip.object-method}
\alias{names<-,flip.object-method}
\alias{sort,flip.object-method}
\alias{hist,flip.object-method}
\alias{plot,flip.object-method}
\title{Class flip.object}
\usage{
\S4method{show}{flip.object}(object)

summary(object, ...)

\S4method{summary}{flip.object}(object, star.signif = TRUE, only.p.leq = NULL, ...)

\S4method{dim}{flip.object}(x)

\S4method{[}{flip.object}(x, i)

\S4method{[[}{flip.object}(x, i)

\S4method{length}{flip.object}(x)

\S4method{names}{flip.object}(x)

\S4method{names}{flip.object}(x) <- value

\S4method{sort}{flip.object}(x, decreasing = FALSE)

\S4method{hist}{flip.object}(x, ...)

\S4method{plot}{flip.object}(x, y, ...)
}
\arguments{
\item{object}{a flip-object}

\item{...}{additional arguments to be passed}

\item{star.signif}{If \code{TRUE} (default), it puts stars on the significant tests}

\item{only.p.leq}{Shows only tests with a p-value lower than \code{only.p.leq}. The default \code{NULL} is equivalent to set \code{only.p.leq=1}.}

\item{x}{a \code{flip.object}.}

\item{i}{indices specifying elements to extract or replace. Indices are \code{numeric}, \code{character} or \code{logical} vectors or empty (missing) or \code{NULL}.}

\item{value}{\code{character} vector of up to the same 
length as \code{x}, or \code{NULL}.}

\item{decreasing}{logical. Should the sort be increasing or decreasing?}

\item{y}{not used.}
}
\description{
The class flip.object is the output of a call to \code{\link{flip}}, \code{\link{flipMix}}, \code{\link{npc}}, \code{\link{flip.adjust}} etc. 
The following are functions to extract and manipulate relevant information from
a \code{flip.object}.
}
\examples{
Y=matrix(rnorm(50),10,5)
colnames(Y)=LETTERS[1:5]
Y[,1:2]=Y[,1:2] +2
res = flip(Y)
res
summary(res)
sort(res)
names(res)
length(res)
dim(res)
res=res[2:3]
res
hist(res)
plot(res)
}
