% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{get_map_border}
\alias{get_map_border}
\title{Helper function to calculate the coordinate limits of map border}
\usage{
get_map_border(v, type = c("long", "lat"), padding_ratio = 0.1)
}
\arguments{
\item{v}{A double numeric vector - vector of longtitudes/latitudes.}

\item{type}{A string - "long" or "lat". It indicates whether longtitudes or latitudes are input.}

\item{padding_ratio}{A double number - 0 to 1. The padding ratio is defined as\cr
padding / (maximum - minimum)}
}
\value{
A two-column dataframe
}
\description{
Since the world map is huge, and flights are usually drawn in a relatively\cr
small area, the map needs to be cropped based on the coordinates of airports\cr
used. This function generates the coordinate limits of the cropped map.
}
\examples{
get_map_border(c(-20,30,60,85), type = "lat")
get_map_border(c(-10,0,10,40), type = "long", padding_ratio = 0.2)

}
