% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flxregnorm.R
\name{FLXMCregnorm}
\alias{FLXMCregnorm}
\title{FlexMix Driver for Regularized Multivariate Normal Mixtures}
\usage{
FLXMCregnorm(formula = . ~ ., params)
}
\arguments{
\item{formula}{A formula which is interpreted relative to the formula
specified in the call to \code{\link[flexmix:flexmix]{flexmix::flexmix()}} using
\code{\link[stats:update.formula]{stats::update.formula()}}. Only the left-hand side (response)
of the formula is used. Default is to
use the original model formula specified in \code{\link[flexmix:flexmix]{flexmix::flexmix()}}.}

\item{params}{Prior parameters for normal mixtures. You may obtain
default values according to Fraley and Raftery (2007) using
\code{FLXMCregnorm_defaults()}.
As the prior depends on the number of components it is probably not
advisable to run \code{stepFlexmix} with more than one value of \code{k} at
a time.}
}
\value{
An object of class \code{"FLXC"}.
}
\description{
This model driver implements the regularization method as
introduced by Fraley and Raftery (2007) for univariate normal
mixtures. Default parameters for the regularization according to
that paper may be obtained using \code{FLXMCregnorm_defaults()}. We
extend this to the multivariate case assuming independence between
variables within components, i.e., we only implement the special
case where the covariance matrix is diagonal. For more general
applications of normal mixtures see package \pkg{mclust}.
}
\details{
For the regularization the conjugate prior distributions for the
normal distribution are used, which are:
\itemize{
\item Normal prior with parameter \code{mu_p} and \code{sigma^2/kappa_p} for the mean.
\item Inverse Gamma prior with parameters \code{nu_p/2} and \code{zeta_p^2/2} for the
variance.
}
}
\examples{
library("flexmix")
library("flexord")
library("flexclust")

# example data
data("iris", package = "datasets")
my_iris <- subset(iris, select=setdiff(colnames(iris), "Species")) |>
    as.matrix()

# cluster one model with a scale parameter similar to the default for 3 components
params <- FLXMCregnorm_defaults(my_iris, zeta_p = c(0.23, 0.06, 1.04, 0.19))
m1 <- stepFlexmix(my_iris ~ 1, k = 3, 
    model=FLXMCregnorm(params = params))
summary(m1)

# rand index of clusters vs species
randIndex(clusters(m1), iris$Species)

# cluster one model with default scale parameter
params <- FLXMCregnorm_defaults(my_iris, k = 3)
m2 <- stepFlexmix(my_iris ~ 1, k = 3,
    model = FLXMCregnorm(params = params))
summary(m2)

# rand index of clusters vs species
randIndex(clusters(m2), iris$Species)

# rand index between both models (should be >= 0.8)
randIndex(clusters(m1), clusters(m2))
}
\references{
\itemize{
\item Ernst, D, Ortega Menjivar, L, Scharl, T, Grün, B (2025).
\emph{Ordinal Clustering with the flex-Scheme.}
Austrian Journal of Statistics. \emph{Submitted manuscript}.
\item Fraley, C, Raftery, AE (2007)
\emph{Bayesian Regularization for Normal Mixture Estimation and Model-Based Clustering.}
Journal of Classification, 24(2), 155-181
}
}
\seealso{
FLXMCregnorm_defaults
}
