% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_operations.R
\name{fuzzy_mults}
\alias{fuzzy_mults}
\title{Multiply two triangular fuzzy numbers}
\usage{
fuzzy_mults(X, Y)
}
\arguments{
\item{X}{List. First triangular fuzzy number with components \code{l}, \code{x}, and \code{r}.}

\item{Y}{List. Second triangular fuzzy number with components \code{l}, \code{x}, and \code{r}.}
}
\value{
A scalar representing the sum of the product of the corresponding components.
}
\description{
Computes the scalar product of two triangular fuzzy numbers.
}
\examples{
X <- list(l = 1, x = 2, r = 3)
Y <- list(l = 2, x = 3, r = 4)
fuzzy_mults(X, Y)
}
